#include "mbed.h"
#include "QEI.h"
#include "MODSERIAL.h"


DigitalOut motor2_direction(D7);
PwmOut motor2_speed_control(D6);
PwmOut motor1_speed_control(D5);
DigitalOut motor1_direction(D4);

DigitalOut led3(LED_BLUE);

Serial pc(USBTX,USBRX); 

QEI Encoder1(D12,D13,NC,32);
QEI Encoder2(D10,D11,NC,32);


int main()
{
    pc.baud(115200);
    
    double counts_m1 = 0;
    double counts_m2 = 0;
    double counts_m1_prev = 0;
    double counts_m2_prev = 0;
    
    counts_m1 = Encoder1.getPulses() - counts_m1_prev;
    counts_m2 = Encoder1.getPulses() - counts_m2_prev;
    deg_m1 = deg_m1 + counts_m1*(360/(full_ratio));
    deg_m2 = deg_m2 + counts_m2*(360/(full_ratio));
    counts_m1_prev = Encoder1.getPulses();
    counts_m2_prev = Encoder2.getPulses();  
    
    while(true)
      {
        pc.printf("counts_m1 = %f, count_m2 = %f, deg_m1 = %f, deg_m2 = %f \r\n",counts_m1,counts_m2,deg_m1,deg_m2);
        if(deg_m1=90 && deg_m2=90)
        {
            led3=0;
            }
       }
}