#include "view2.h"

View2::View2(int width, int height) : m_width(width), m_height(height){}

View2::~View2()                                                                                //Destructeur de bouton
{
    for (Button * button : m_buttonList) {
        delete button;
    }
    m_buttonList.clear();
}


void View2::contain(int x, int y)
{
    if(screenReleased){
        screenReleased=false;
        for (Button * button : m_buttonList) {
            if (button->contain(x,y)) {
                updateViewChanged(button);
            }
        }
    }
}


void View2::draw()
{
    BSP_LCD_Clear(m_bgColor);                                 //Enlève l'affichage du début
    for (Button * button : m_buttonList) {
        button->draw();
    }
}


void View2::initView(){
    m_bgColor = LCD_COLOR_BLACK;
    //Animations
    anim1->setText("Animations1");
    anim2->setText("Animations2");
    anim3->setText("Animations3");
    start->setText("Start animation");
    stop->setText("Stop animation");
    //Animations tab
    animations->setText("Animations", LCD_COLOR_BLACK);
    //LEDs tab
    leds->setText("LEDS", LCD_COLOR_WHITE);
    hideTop2->setText("");
    hideRight2->setText("");
    //Animations
    m_buttonList.push_front(anim1);
    m_buttonList.push_front(anim2);
    m_buttonList.push_front(anim3);
    m_buttonList.push_front(start);
    m_buttonList.push_front(stop);
    //Animations tab
    m_buttonList.push_front(animations);
    //LEDs tab
    m_buttonList.push_front(hideRight2);
    m_buttonList.push_front(hideTop2);
    m_buttonList.push_front(leds);
}

void View2::updateLCD(){
    viewChanged = false;
    BSP_TS_GetState(&TS_State);
    if (TS_State.touchDetected) {                                                        //Detecte si l'écran tactile est touché
        cleared = false;
        for (idx = 0; idx < TS_State.touchDetected; idx++) {
            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];
            contain(x, y);

        }
    } else {
        screenReleased=true;
        if (!cleared) {
            draw();
            cleared = true;

        }
    }

}

void View2::updateViewChanged(Button* button){
    if(button == leds){
        viewChanged=true;
    }
}

void View2::updateAnim1(Button* button){
    if(button == anim1){
        anim1Bool=true;
    }
}

bool View2::getAnim1(){
    return anim1Bool;
}


void View2::setAnim1(bool viewChanged){
    anim1Bool = this->anim1Bool;
}

bool View2::getViewChanged(){
    return viewChanged;
}


void View2::setViewChanged(bool viewChanged){
    viewChanged = this->viewChanged;
}