#ifndef VIEW2_H
#define VIEW2_H
#include "mbed.h"
#include "button.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include <list>
#include <stdlib.h>
#define SCREENWIDTH 480
#define SCREENHEIGHT 272
#define LED_BUTTON_SIZE 40
#define RGB_TEXT_VIEW_WIDTH 30
#define RGB_TEXT_VIEW_HEIGHT 15
#define PLUS_MINUS_BUTTON_SIZE 30
#define ANIMATION_BUTTON_WIDTH 80
#define ANIMATION_BUTTON_HEIGHT 15
#define LIGHT_GRAY (uint32_t)0xFFe0e0d1


class View2
{
public:
    View2(int width = SCREENWIDTH, int height = SCREENHEIGHT);
    void contain(int x, int y);
    void draw();
    void updateLCD();
    void updateViewChanged(Button* button);
    bool getViewChanged();
    void setViewChanged(bool viewChanged);
    void updateAnim1(Button* button);
    bool getAnim1();
    void setAnim1(bool viewChanged);
    void initView();
    ~View2();  

private :
    void drawText();
    int16_t m_width = SCREENWIDTH;
    int16_t m_height = SCREENHEIGHT;
    uint32_t m_bgColor = LCD_COLOR_WHITE;
    list<Button *> m_buttonList;
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t idx;
    bool screenReleased=true;
    bool cleared = false;
    uint8_t RGB[3]={0x00, 0x00, 0x00};
    char str[10];
    bool ledSelected[12]={false, false, false, false,
                          false, false, false, false,
                          false, false, false, false};
    bool viewChanged= false;
    bool anim1Bool= false;
    
    //Animations
    Button *anim1  = new Button(20, 38, ANIMATION_BUTTON_WIDTH, ANIMATION_BUTTON_HEIGHT, LIGHT_GRAY);
    Button *anim2  = new Button(20, 68, ANIMATION_BUTTON_WIDTH, ANIMATION_BUTTON_HEIGHT, LIGHT_GRAY);
    Button *anim3 = new Button(20, 98, ANIMATION_BUTTON_WIDTH, ANIMATION_BUTTON_HEIGHT, LIGHT_GRAY);
    Button *start  = new Button(20, 128, 120, ANIMATION_BUTTON_HEIGHT+5, LIGHT_GRAY);
    Button *stop  = new Button(20, 163, 120, ANIMATION_BUTTON_HEIGHT+5, LIGHT_GRAY);
    //Animations tab
    Button *animations = new Button(397, 0, 83, 25, LCD_COLOR_WHITE, LCD_COLOR_WHITE);
    //LEDs tab
    Button *leds = new Button(397, 0+25, 83, 25, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *hideTop2 = new Button(397, 0+25, 82, 1, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *hideRight2 = new Button(479, 0+25, 1, 24, LCD_COLOR_BLACK, LCD_COLOR_WHITE);

};

#endif
