#ifndef VIEW_H
#define VIEW_H
#include "mbed.h"
#include "button.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "neoPixelRing12/neoPixelRing12.h"
#include <list>
#include <stdlib.h>
#define SCREENWIDTH 480
#define SCREENHEIGHT 272
#define LED_BUTTON_SIZE 40
#define RGB_TEXT_VIEW_WIDTH 60
#define RGB_TEXT_VIEW_HEIGHT 30
#define PLUS_MINUS_BUTTON_SIZE 30
#define ANIMATION_BUTTON_WIDTH 80
#define ANIMATION_BUTTON_HEIGHT 15
#define LIGHT_GRAY (uint32_t)0xFFe0e0d1


class View1
{
public:
    View1(int width = SCREENWIDTH, int height = SCREENHEIGHT);
    void contain(int x, int y);
    void draw();
    void updateLCD();
    bool updatePlusMinus(Button* button);
    bool updateLEDS(Button* button);
    bool updateSetNewColorAndCancel(Button* button);
    void updateViewChanged(Button* button);
    bool getViewChanged();
    void setViewChanged(bool viewChanged);
    void initView();
    void getRGBmap(char RGBmap[12][7]);
    bool getSetNewColorEnabled();
    ~View1();

private :
    void drawText();
    int16_t m_width = SCREENWIDTH;
    int16_t m_height = SCREENHEIGHT;
    uint32_t m_bgColor = LCD_COLOR_WHITE;
    list<Button *> m_buttonList;
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t idx;
    bool screenReleased=true;
    bool cleared = false;
    uint8_t RGB[3]={0x00, 0x00, 0x00};
    char str[10];
    bool ledSelected[12]={false, false, false, false,
                          false, false, false, false,
                          false, false, false, false};
    bool viewChanged= false;
    char RGBmap[12][7];
    bool setNewColorEnabled=false;
    
    //LEDS buttons
    Button *led0 = new Button(300, 5, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led1 = new Button(353, 20, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led2 = new Button(397, 65, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led3 = new Button(410, 118, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led4 = new Button(396, 170, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led5 = new Button(354, 212, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led6 = new Button(300, 227, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led7 = new Button(245, 212, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led8 = new Button(204, 170, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led9 = new Button(190, 118, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led10 = new Button(203, 62, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *led11 = new Button(245, 20, LED_BUTTON_SIZE, LED_BUTTON_SIZE, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    //RGB TextView
    Button *redTextview = new Button(90, 30, RGB_TEXT_VIEW_WIDTH, RGB_TEXT_VIEW_HEIGHT, LCD_COLOR_RED);
    Button *greenTextview  = new Button(90, 120, RGB_TEXT_VIEW_WIDTH, RGB_TEXT_VIEW_HEIGHT, LCD_COLOR_GREEN);
    Button *blueTextview  = new Button(90, 210, RGB_TEXT_VIEW_WIDTH, RGB_TEXT_VIEW_HEIGHT, LCD_COLOR_BLUE);
    //RGB + and -
    Button *plusRED = new Button(185-130, 8, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *minusRED  = new Button(185-130, 53, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *plusGREEN  = new Button(185-130, 98, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *minusGREEN = new Button(185-130, 143, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *plusBLUE  = new Button(185-130, 188, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *minusBLUE  = new Button(185-130, 233, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *plus10RED = new Button(185-35-130, 8, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *minus10RED  = new Button(185-35-130, 53, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *plus10GREEN  = new Button(185-35-130, 98, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *minus10GREEN = new Button(185-35-130, 143, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *plus10BLUE  = new Button(185-35-130, 188, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    Button *minus10BLUE  = new Button(185-35-130, 233, PLUS_MINUS_BUTTON_SIZE, PLUS_MINUS_BUTTON_SIZE, LIGHT_GRAY);
    //SET NEW COLOR
    Button *setNewColor  = new Button(270, 100, 100, 25, LIGHT_GRAY);
    Button *cancel  = new Button(270, 150, 100, 25, LIGHT_GRAY);
    //Animations tab
    Button *animations = new Button(397, 0, 83, 25, LCD_COLOR_BLACK, LCD_COLOR_WHITE);
    Button *hideTop = new Button(397, 0, 82, 1, LCD_COLOR_BLACK, LCD_COLOR_BLACK);
    Button *hideRight = new Button(479, 0, 1, 24, LCD_COLOR_BLACK, LCD_COLOR_BLACK);
    //LEDs tab
    Button *leds = new Button(397, 0+25, 83, 25, LCD_COLOR_WHITE, LCD_COLOR_WHITE);

};

#endif
