#include "view1.h"

View1::View1(int width, int height) : m_width(width), m_height(height){}

View1::~View1()                                                                                //Destructeur de bouton
{
    for (Button * button : m_buttonList) {
        delete button;
    }
    m_buttonList.clear();
}


void View1::contain(int x, int y)
{
    if(screenReleased){
        screenReleased=false;
        for (Button * button : m_buttonList) {
            if (button->contain(x,y)) {
                updatePlusMinus(button);
                updateLEDS(button);
                updateSetNewColorAndCancel(button);
                updateViewChanged(button);
            }
        }
    }
}


void View1::draw()
{
    BSP_LCD_Clear(m_bgColor);                                 //Enlève l'affichage du début
    for (Button * button : m_buttonList) {
        button->draw();
    }
    drawText();
}


void View1::initView(){
    for(int y=0; y<12; y++){
      strcpy(RGBmap[y], "000000");
    }
    m_bgColor = LCD_COLOR_BLACK;
    //LEDS
    led0->setText("");
    led1->setText("");
    led2->setText("");
    led3->setText("");
    led4->setText("");
    led5->setText("");
    led6->setText("");
    led7->setText("");
    led8->setText("");
    led9->setText("");
    led10->setText("");
    led11->setText("");
    //RGB TextView
    redTextview->setText("000");
    greenTextview->setText("000");
    blueTextview->setText("000");
    //RGB + and -
    plusRED->setText("+1");
    minusRED->setText("-1");
    plusGREEN->setText("+1");
    minusGREEN->setText("-1");
    plusBLUE->setText("+1");
    minusBLUE->setText("-1");
    plus10RED->setText("+10");
    minus10RED->setText("-10");
    plus10GREEN->setText("+10");
    minus10GREEN->setText("-10");
    plus10BLUE->setText("+10");
    minus10BLUE->setText("-10");
    //SET NEW COLOR
    setNewColor->setText("SET NEW COLOR");
    cancel->setText("CANCEL");
    //Animations tab
    animations->setText("Animations", LCD_COLOR_WHITE);
    hideTop->setText("");
    hideRight->setText("");
    //LEDs tab
    leds->setText("LEDS", LCD_COLOR_BLACK);
    //LEDS buttons
    m_buttonList.push_front(led0);
    m_buttonList.push_front(led1);
    m_buttonList.push_front(led2);
    m_buttonList.push_front(led3);
    m_buttonList.push_front(led4);
    m_buttonList.push_front(led5);
    m_buttonList.push_front(led6);
    m_buttonList.push_front(led7);
    m_buttonList.push_front(led8);
    m_buttonList.push_front(led9);
    m_buttonList.push_front(led10);
    m_buttonList.push_front(led11);
    //RGB TextView
    m_buttonList.push_front(redTextview);
    m_buttonList.push_front(greenTextview);
    m_buttonList.push_front(blueTextview);
    //RGB + and -
    m_buttonList.push_front(plusRED);
    m_buttonList.push_front(minusRED);
    m_buttonList.push_front(plusGREEN);
    m_buttonList.push_front(minusGREEN);
    m_buttonList.push_front(plusBLUE);
    m_buttonList.push_front(minusBLUE);
    m_buttonList.push_front(plus10RED);
    m_buttonList.push_front(minus10RED);
    m_buttonList.push_front(plus10GREEN);
    m_buttonList.push_front(minus10GREEN);
    m_buttonList.push_front(plus10BLUE);
    m_buttonList.push_front(minus10BLUE);
    //SET NEW COLOR
    m_buttonList.push_front(setNewColor);
    m_buttonList.push_front(cancel);
    //Animations tab
    m_buttonList.push_front(hideRight);
    m_buttonList.push_front(hideTop);
    m_buttonList.push_front(animations);
    //LEDs tab
    m_buttonList.push_front(leds);
}

void View1::drawText(){
    //(uint32_t)0xFFFFFFFF
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_DisplayStringAt(90,10,(uint8_t *)"Red", LEFT_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
    BSP_LCD_DisplayStringAt(90,100,(uint8_t *)"Green", LEFT_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_DisplayStringAt(90,190,(uint8_t *)"Blue", LEFT_MODE);
}

void View1::updateLCD(){
    setNewColorEnabled = false;
    viewChanged = false;
    BSP_TS_GetState(&TS_State);
    if (TS_State.touchDetected) {                                                        //Detecte si l'écran tactile est touché
        cleared = false;
        for (idx = 0; idx < TS_State.touchDetected; idx++) {
            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];
            contain(x, y);

        }
    } else {
        screenReleased=true;
        if (!cleared) {
            draw();
            cleared = true;
        }
    }

}

bool View1::updatePlusMinus(Button* button){
        if(button == plusRED){
            RGB[0]= std::atoi((const char*)redTextview->getText());
            RGB[0]++;
            sprintf(str, "%d", RGB[0]);
            redTextview->setText(str);           
        } else if(button == minusRED){
            RGB[0]= std::atoi((const char*)redTextview->getText());
            RGB[0]--;
            sprintf(str, "%d", RGB[0]);
            redTextview->setText(str);  
        } else if(button == plus10RED){
            RGB[0]= std::atoi((const char*)redTextview->getText());
            RGB[0]+=10;
            sprintf(str, "%d", RGB[0]);
            redTextview->setText(str);           
        } else if(button == minus10RED){
            RGB[0]= std::atoi((const char*)redTextview->getText());
            RGB[0]-=10;
            sprintf(str, "%d", RGB[0]);
            redTextview->setText(str);  
        } else if(button == plusGREEN){
            RGB[1]= std::atoi((const char*)greenTextview->getText());
            RGB[1]++;
            sprintf(str, "%d", RGB[1]);
            greenTextview->setText(str);           
        } else if(button == minusGREEN){
            RGB[1]= std::atoi((const char*)greenTextview->getText());
            RGB[1]--;
            sprintf(str, "%d", RGB[1]);
            greenTextview->setText(str);  
        } else if(button == plus10GREEN){
            RGB[1]= std::atoi((const char*)greenTextview->getText());
            RGB[1]+=10;
            sprintf(str, "%d", RGB[1]);
            greenTextview->setText(str);           
        } else if(button == minus10GREEN){
            RGB[1]= std::atoi((const char*)greenTextview->getText());
            RGB[1]-=10;
            sprintf(str, "%d", RGB[1]);
            greenTextview->setText(str);  
        }else if(button == plusBLUE){
            RGB[2]= std::atoi((const char*)blueTextview->getText());
            RGB[2]++;
            sprintf(str, "%d", RGB[2]);
            blueTextview->setText(str);           
        } else if(button == minusBLUE){
            RGB[2]= std::atoi((const char*)blueTextview->getText());
            RGB[2]--;
            sprintf(str, "%d", RGB[2]);
            blueTextview->setText(str);  
        } else if(button == plus10BLUE){
            RGB[2]= std::atoi((const char*)blueTextview->getText());
            RGB[2]+=10;
            sprintf(str, "%d", RGB[2]);
            blueTextview->setText(str);           
        } else if(button == minus10BLUE){
            RGB[2]= std::atoi((const char*)blueTextview->getText());
            RGB[2]-=10;
            sprintf(str, "%d", RGB[2]);
            blueTextview->setText(str);  
        } else
            return false;  
    
        return true;
}

bool View1::updateLEDS(Button* button){
    if(button == led0)
        if(!ledSelected[0]){
            ledSelected[0]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[0]=false;
            button->setBorderWidth(1);
        }
    else if(button == led1)
        if(!ledSelected[1]){
            ledSelected[1]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[1]=false;
            button->setBorderWidth(1);
        }     
    else if(button == led2)
        if(!ledSelected[2]){
            ledSelected[2]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[2]=false;
            button->setBorderWidth(1);
        }
    else if(button == led3)
        if(!ledSelected[3]){
            ledSelected[3]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[3]=false;
            button->setBorderWidth(1);
        }     
    else if(button == led4)
        if(!ledSelected[4]){
            ledSelected[4]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[4]=false;
            button->setBorderWidth(1);
        }   
    else if(button == led5)
        if(!ledSelected[5]){
            ledSelected[5]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[5]=false;
            button->setBorderWidth(1);
        }        
    else if(button == led6)
        if(!ledSelected[6]){
            ledSelected[6]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[6]=false;
            button->setBorderWidth(3);
        }    
    else if(button == led7)
        if(!ledSelected[7]){
            ledSelected[7]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[7]=false;
            button->setBorderWidth(1);
        }    
    else if(button == led8)
        if(!ledSelected[8]){
            ledSelected[8]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[8]=false;
            button->setBorderWidth(1);
        }    
    else if(button == led9)
        if(!ledSelected[9]){
            ledSelected[9]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[9]=false;
            button->setBorderWidth(1);
        }     
        else if(button == led10)
        if(!ledSelected[10]){
            ledSelected[10]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[10]=false;
            button->setBorderWidth(1);
        }    
    else if(button == led11)
        if(!ledSelected[11]){
            ledSelected[11]=true;
            button->setBorderWidth(3);
        }
        else{
            ledSelected[11]=false;
            button->setBorderWidth(1);
        }    
    else
        return false;
        
    return true;
}

bool View1::updateSetNewColorAndCancel(Button* button){
    int i=0;
    uint32_t RGBcolor=0xFF000000;
    if(button == cancel){
        led0->setBorderWidth(1);
        led1->setBorderWidth(1);
        led2->setBorderWidth(1);
        led3->setBorderWidth(1);
        led4->setBorderWidth(1);
        led5->setBorderWidth(1);
        led6->setBorderWidth(1);
        led7->setBorderWidth(1);
        led8->setBorderWidth(1);
        led9->setBorderWidth(1);
        led10->setBorderWidth(1);
        led11->setBorderWidth(1);

    }else if(button == setNewColor){
        setNewColorEnabled = true;
        RGBcolor+=RGB[2]+(RGB[1]<<8)+(RGB[0]<<16);
        led0->setBorderWidth(1);
        led1->setBorderWidth(1);
        led2->setBorderWidth(1);
        led3->setBorderWidth(1);
        led4->setBorderWidth(1);
        led5->setBorderWidth(1);
        led6->setBorderWidth(1);
        led7->setBorderWidth(1);
        led8->setBorderWidth(1);
        led9->setBorderWidth(1);
        led10->setBorderWidth(1);
        led11->setBorderWidth(1);
        if(ledSelected[0]){
            led0->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x000000ff);
            strcpy(RGBmap[0], str);
        }if(ledSelected[1]){
            led1->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[1], str);
        }if(ledSelected[2]){
            led2->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[2], str);
        }if(ledSelected[3]){
            led3->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[3], str);
        }if(ledSelected[4]){
            led4->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[4], str);
        }if(ledSelected[5]){
            led5->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[5], str);
        }if(ledSelected[6]){
            led6->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[6], str);
        }if(ledSelected[7]){
            led7->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[7], str);
        }if(ledSelected[8]){
            led8->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[8], str);
        }if(ledSelected[9]){
            led9->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[9], str);
        }if(ledSelected[10]){
            led10->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[10], str);
        }if(ledSelected[11]){
            led11->setBackgroundColor(RGBcolor);
            sprintf(str, "%06x", RGBcolor & 0x00ffffff);
            strcpy(RGBmap[11], str);
        }
    }else
        return false;

    for(i=0; i<12; i++)
        ledSelected[i]=false;
    return true;
}

void View1::updateViewChanged(Button* button){
    if(button == animations){
        viewChanged=true;
    }
}

bool View1::getViewChanged(){
    return viewChanged;
}

void View1::setViewChanged(bool viewChanged){
    this->viewChanged = viewChanged;
}

void View1::getRGBmap(char RGBmap[12][7]){
    for(int i=0; i<12; i++)
        for(int y=0; y<6; y++)
            RGBmap[i][y] = this->RGBmap[i][y];
}

bool View1::getSetNewColorEnabled(){
  return setNewColorEnabled;   
}