#ifndef NEO_PIXEL_RING_12
#define NEO_PIXEL_RING_12
 
#include "mbed.h"
#include "string.h" 
#include <stdlib.h>

#define RST_TIME_IN_US 70

class NeoPixelRing12
{
    public:
        NeoPixelRing12(DigitalOut _digitalOutPin);
        bool rst();
        bool rgbToDataStructure(char* rgbCode);
        bool bit(bool value);
        bool setLights(int nbOfLeds, char* rgbCode); 
        bool setLights(char RGBmap[12][7]);  
        bool initLights();
        bool setLightsNoReset(int nbOfLeds, char* rgbCode);   
        bool circleUpAnimations();   
        bool ironManRepulsorBlastAnimations(); 
        bool rainbowAnimations();
  
    private:
        DigitalOut digitalOutPin;
        bool rgbDataStructure[24];
};

#endif