#include "neoPixelRing12.h"
#include "mbed.h"
#include "string.h"

NeoPixelRing12::NeoPixelRing12(DigitalOut _digitalOutPin):digitalOutPin(_digitalOutPin)
{
}

bool NeoPixelRing12::rst( )
{
        digitalOutPin=0;
        wait_us(RST_TIME_IN_US);
        return true;
}

bool NeoPixelRing12::rgbToDataStructure(char* rgbCode){
    uint8_t i = 0; 
    uint8_t offset = 0; 
    
    //Red
    for (i=0; i<6; i++) { 
        if(i==0)
            offset=11;
        if(i==1)
            offset=15;
        if(i==2)
            offset=3;
        if(i==3)
            offset=7;
        if(i==4)
            offset=19;
        if(i==5)
            offset=23; 
        switch (rgbCode[i]) { 
        case '0': 
            //////////cout << "0000"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=false;          
            break; 
        case '1': 
            ////////////////////cout << "0001"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '2': 
            ////////cout << "0010"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '3': 
            ////////cout << "0011"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '4': 
            ////////cout << "0100"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '5': 
            ////////cout << "0101"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '6': 
            ////////cout << "0110"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '7': 
            ////////cout << "0111"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=false; 
            break; 
        case '8': 
            ////////cout << "1000"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=true;  
            break; 
        case '9': 
            ////////cout << "1001"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=true;  
            break; 
        case 'A': 
        case 'a': 
            ////////cout << "1010"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=true;  
            break; 
        case 'B': 
        case 'b': 
            ////////cout << "1011"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=false;
            rgbDataStructure[offset-3]=true;  
            break; 
        case 'C': 
        case 'c': 
            ////////cout << "1100"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=true;  
            break; 
        case 'D': 
        case 'd': 
            ////////cout << "1101"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=false;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=true; 
            break; 
        case 'E': 
        case 'e': 
            ////////cout << "1110"; 
            rgbDataStructure[offset]=false;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=true;  
            break; 
        case 'F': 
        case 'f': 
            ////////cout << "1111"; 
            rgbDataStructure[offset]=true;
            rgbDataStructure[offset-1]=true;
            rgbDataStructure[offset-2]=true;
            rgbDataStructure[offset-3]=true;  
            break; 
        default: 
            return false;
        } 
    }
    return true;   
}

bool NeoPixelRing12::bit(bool value){
    if(!value){
        digitalOutPin = 1; 
        wait_ns(190); 
        digitalOutPin = 0;
        wait_ns(740);
    }
    else{
        digitalOutPin = 1; 
        wait_ns(440); 
        digitalOutPin = 0;
        wait_ns(440);
    }
    return true;
}

bool NeoPixelRing12::setLights(int nbOfLeds, char* rgbCode){
    initLights();
    rgbToDataStructure(rgbCode);
    for(int i=0; i<nbOfLeds; i++){
        for(int y=0; y<24; y++){
            bit(rgbDataStructure[y]);
        }
    }
    rst();
    return true;
}

bool NeoPixelRing12::setLights(char RGBmap[12][7]){
    char* buffer; 
    //initLights();
    for(int i=0; i<12; i++){      
        buffer=&RGBmap[i][0];
        rgbToDataStructure(buffer);
        for(int y=0; y<24; y++){
            bit(rgbDataStructure[y]);
        }
    }
    rst();
    return true;
}


bool NeoPixelRing12::initLights(){
    for(int y=0; y<24; y++){
        bit(0);
    }
    rst();
    return true;
}

bool NeoPixelRing12::setLightsNoReset(int nbOfLeds, char* rgbCode){
    rgbToDataStructure(rgbCode);
    for(int i=0; i<nbOfLeds; i++){
        for(int y=0; y<24; y++){
            bit(rgbDataStructure[y]);
        }
    }
    return true;
}

bool NeoPixelRing12::circleUpAnimations(){
    char buffer=0;
    uint32_t rgb=0;
    char str[7];
    char redBuffer[256][7], greenBuffer[256][7], blueBuffer[256][7];
    int i, y, z, x;
     for(i=0; i<36; i++){
        buffer+=7;
        rgb = (buffer<<16);
        sprintf(str, "%06x", rgb & 0xffffff);
        strcpy(redBuffer[i], str);
        rgb = (buffer<<8);
        sprintf(str, "%06x", rgb & 0xffffff);
        strcpy(greenBuffer[i], str);
        rgb = buffer;
        sprintf(str, "%06x", rgb & 0xffffff);
        strcpy(blueBuffer[i], str);
    } 
    x=0;
    for(y=0; y<3; y++){
        for(i=0; i<12; i++){
            x++;
            initLights();
            for(z=0; z<i; z++)
                setLightsNoReset(1, redBuffer[x-z]);
            setLightsNoReset(1, redBuffer[x]);
            rst();
            wait(0.07); 
        }
        for(i=1; i<=12; i++){
            initLights();
            setLightsNoReset(i, "000000");
            rst();
            wait(0.07); 
        }
    } 
    x=0;
    for(y=0; y<3; y++){
        for(i=0; i<12; i++){
            x++;
            initLights();
            for(z=0; z<i; z++)
                setLightsNoReset(1, greenBuffer[x-z]);
            setLightsNoReset(1, greenBuffer[x]);
            rst();
            wait(0.07); 
        }
        for(i=1; i<=12; i++){
            initLights();
            setLightsNoReset(i, "000000");
            rst();
            wait(0.07); 
        }
    } 
    x=0;
    for(y=0; y<3; y++){
        for(i=0; i<12; i++){
            x++;
            initLights();
            for(z=0; z<i; z++)
                setLightsNoReset(1, blueBuffer[x-z]);
            setLightsNoReset(1, blueBuffer[x]);
            rst();
            wait(0.07); 
        }
        for(i=1; i<=12; i++){
            setLights(i, "000000");
            wait(0.07); 
        }
    }   
    return true;
}

bool NeoPixelRing12::ironManRepulsorBlastAnimations(){
    char buffer=0;
    uint32_t rgb=0;
    char str[7];
    char rgbBuffer[256][7];
    int i, y;
     for(i=0; i<256; i++){
        buffer++;
        rgb = (buffer<<16) + (buffer<<8) + buffer;
        sprintf(str, "%06x", rgb & 0xffffff);
        strcpy(rgbBuffer[i], str);
    } 
    for(i=0; i<50; i++){
        setLights(12, rgbBuffer[i]);
        wait(0.02);
    }
    setLights(12, "000000");
    wait(0.1);
    setLights(12, "ffffff");
    wait(0.1);
    setLights(12, "000000");
    wait(0.1);    
    setLights(12, "ffffff");
    wait(0.1);
    for(y=0; y<5; y++){
        for(i=0; i<50; i++){
            setLights(12, rgbBuffer[i]);
            wait(0.045);
        }
        for(i=50; i>=0; i--){
            setLights(12, rgbBuffer[i]);
            wait(0.045);
        }
    }
    return true;
}

bool NeoPixelRing12::rainbowAnimations(){
    char buffer=0;
    uint32_t rgb=0;
    char redBuffer[12][7]= {{"660000"},{"663300"},{"666600"},{"3366"},
                            {"006600"},{"006633"},{"006666"},{"003366"},
                            {"000066"},{"330066"},{"660066"},{"660033"}};
    int i, y, z, x;
    for(i=0; i<12; i++){
        initLights();
        for(z=0; z<i; z++)
            setLightsNoReset(1, redBuffer[i-z]);
        setLightsNoReset(1, redBuffer[i]);
        rst();
        wait(0.07); 
    }
    for(i=1; i<=12; i++){
        initLights();
        setLightsNoReset(i, "000000");
        rst();
        wait(0.07); 
    }  
    return true;
}

