#include "mbed.h"
#include "Thread.h"
#include "rtos_idle.h"
#include "mbed_critical.h"
#include "neoPixelRing12/neoPixelRing12.h"
#include "view1.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "lcd/lcd.h"
#include "view2/view2.h"
#include "rtos.h"
#include <list>
#define SCREENWIDTH 480
#define SCREENHEIGHT 272
 
#define  USE_CRITICAL_SECTION_LOCK      1   // Set 0 to see race condition

NeoPixelRing12 npr(D8);
LCD disco;
View1 v1;
View2 v2;
TS_StateTypeDef TS_State;
char RGBmap[12][7];
Thread t1;
Thread t2;

void ui() {
    while (true) {
        if(!v1.getViewChanged()){
            v1.updateLCD();  
            if(v1.getSetNewColorEnabled()){
                t2.signal_set(0x1);
            }
        }else{
            v2.updateLCD();
            v1.setViewChanged(!v2.getViewChanged());
        } 
        Thread::wait(1); 
    }
}
 
void leds() {
    while (true) {
        //Set la couleur des LEDS configurés sur la view1
        Thread::signal_wait(0x1, osWaitForever);
        v1.getRGBmap(RGBmap);
        CriticalSectionLock  lock;
        npr.setLights(RGBmap);
        CriticalSectionLock  unlock;
    }
}
 
int main() {
    npr.setLights(12, "000000");
    disco.initLCD();
    v1.initView();
    v2.initView();
    t1.start(ui);
    t2.start(leds);
    Thread::wait(osWaitForever); 
}




