// mbed HRM1017 Eddystone
// Programed by Kazuyuki Eguchi

#include "mbed.h"
#include "BLE.h"

BLEDevice ble;

static const uint16_t uuid16_list[]        = {0xFEAA};

const static uint8_t beaconPayload_uid[] = {
    0xaa,
    0xfe,

    // UID

    0x00, // Frame Type
    0x00, // Ranging Data

    0x01, // NID[0]
    0x02, // NID[1]
    0x03, // NID[2]
    0x04, // NID[3]
    0x05, // NID[4]
    0x06, // NID[5]
    0x07, // NID[6]
    0x08, // NID[7]
    0x09, // NID[8]
    0x0A, // NID[9]

    0x11, // BID[0] 
    0x22, // BID[1]
    0x33, // BID[2]
    0x44, // BID[3]
    0x55, // BID[4]
    0x66, // BID[5]
    0x00, // RFU
    0x00  // RFU
};

const static uint8_t beaconPayload_url[] = {
    0xaa,
    0xfe,

    // URL

    0x10, // Frame Type
    0x00, // Ranging Data
    0x02, // URL Scheme (http:// = 0x02)

    'c',
    'u',
    'b',
    'e',
    'a',
    'c',
    'o',
    'n',
    '.',
    'c',
    'o',
    'm'
};

const static uint8_t beaconPayload_tlm[] = {
    0xaa,
    0xfe,

    // TLM

    0x20, // Frame Type
    0x00, // Version
    0x01, // VBATT[0]
    0x00, // VBATT[1]
    0x02, // TEMP[0]
    0x00, // TEMP[1]
    0x03, // ADV[0]
    0x00, // ADV[1]
    0x00, // ADV[2]
    0x00, // ADV[3]
    0x04, // SEC_CNT[0]
    0x00, // SEC_CNT[1]
    0x00, // SEC_CNT[2]
    0x00 // SEC_CNT[3]
};


int main(void)
{
    ble.init();

    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);

    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));

    ble.accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA,beaconPayload_uid, sizeof(beaconPayload_uid));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA,beaconPayload_url, sizeof(beaconPayload_url));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA,beaconPayload_tlm, sizeof(beaconPayload_tlm));

    ble.setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);

    ble.setAdvertisingInterval(160);

    ble.startAdvertising();

    for (;;) {
        ble.waitForEvent();
    }
}