#ifndef BEAM_H
#define BEAM_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Spacecraft.h"

// gap from edge of screen
#define GAP 2

/** Beam Class
 * @brief  Player's spacecraft beam
 * @author Rex Roshan Raj
 */
class Beam
{

public:

    /** Constructor */
    Beam();
    
    /** Destructor */
    ~Beam();

    /** Initialise the parameters for the player's spacecraft beam 
    *@param size - size of the beam
    *@param a - x position of the spacecraft's beam
    *@param b - y position of the spacecraft's beam
    */
    void init(int size,int a, int b);
    
    /** Updates the beam 
    * @brief Changes the x position of the beam once it has been pressed 
    */ 
    void update();
    
    /** Draws the player's spacecraft beam
    * @param N5110 lcd
    */
    void draw(N5110 &lcd);
    
    /** Gets the position of the player's spacecraft beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos();
    
    /** Sets the position of the player's spacecraft beam 
    *   @brief Position of the player's spacecraft beam
    *   @param position
    */
    void set_pos(Vector2D p);
    
private:

    
    Spacecraft _p1;
     
    int _speed;
    int _size;
    
    int _x;
    int _y;
    int _a;
    int _b;

};

#endif