#ifndef SPACECRAFT_H
#define SPACECRAFT_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Spacecraft Class
 * @brief  Player's spacecraft
 * @author Rex Roshan Raj
 */
class Spacecraft
{

public:

    /** Constructor */
    Spacecraft();
    
    /** Destructor */
    ~Spacecraft();
    
    /** Initialise the parameters for the player's spacecraft 
    *@param a - x position of the enemy
    *@param b - y position of the enemy
    */
    void init(int x,int y);
    
    /** Draws the player's spacecraft 
    * @param N5110 lcd
    */
    void character(N5110 &lcd);
    
    /** Updates the direction 
    * @param Direction d - the direction the player moves using joystick
    * @param mag - magnitude of the how fast the player moves 
    * @brief Changes the direction based on the position of the joystick
    */ 
    void update(Direction d,float mag);
    
    /** Updates move
    * @brief Moves the spacecraft down when the player dies
    */ 
    void update_move();
    
    /** Adds the value of health by 1 */ 
    void add_health();
    
    /** Gets the value of the health 
    * @returns value in range 0 to 6
    */
    int get_health();
    
    /** Gets the position of the player's spacecraft
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos();
    
private:

    int _x;
    int _y;
    int _speed;
    int _health;
    int _increment;

};

#endif