#include "EnemyBeam3.h"

EnemyBeam3::EnemyBeam3()
{

}

EnemyBeam3::~EnemyBeam3()
{

}

void EnemyBeam3::init(int size,int a, int b ,int c, int d, int e, int f) // initialising beam for all the enemy in the third stage
{
    _size = size; // size of the beam
    _x = _size;   // length of the beam
    _y = 1;       // height of the beam
    _a = a;       // x position of the boss enemy beam 
    _b = b + 6;   // y position of the boss enemy beam
    _c = c;       // x position of the first enemy beam 
    _d = d + 3;   // y position of the first enemy beam 
    _e = e;       // x position of the second enemy beam 
    _f = f + 3;   // y position of the second enemy beam 
}

void EnemyBeam3::draw(N5110 &lcd)
{
    int random = rand()%4;
    if(random < 2){
    // draws the beam of the enemy boss    
    lcd.drawRect(_a,_b,_x,_y,FILL_BLACK);
    }
    // draws the beam of the first regular enemy 
    lcd.drawRect(_c,_d,_x,_y,FILL_BLACK);
    // draws the beam of the second regular enemy
    lcd.drawRect(_e,_f,_x,_y,FILL_BLACK);
}

void EnemyBeam3::update()
{
    _speed = 5.0;  // the speed of the beam moving is set at 5
    
    // moves the enemy beams in the negative x direction
    _a-=_speed;   
    _c-=_speed;
    _e-=_speed;
    
}

Vector2D EnemyBeam3::get_pos_boss()
{
    // gets the position of the enemy boss beam
    Vector2D b = {_a,_b};
    return b;
}

Vector2D EnemyBeam3::get_pos_enemy1()
{
    // gets the position of the first enemy beam
    Vector2D c = {_c,_d};
    return c;
}

Vector2D EnemyBeam3::get_pos_enemy2()
{
    // gets the position of the second enemy beam
    Vector2D d = {_e,_f};
    return d;
}
void EnemyBeam3::set_pos_boss(Vector2D p)
{
    // sets the position of the enemy boss beam
    _a = p.x ;
    _b = p.y ;
}

void EnemyBeam3::set_pos_enemy1(Vector2D p)
{
    // gets the position of the first enemy beam
    _c = p.x ;
    _d = p.y ;
}

void EnemyBeam3::set_pos_enemy2(Vector2D p)
{
    // gets the position of the second enemy beam
    _e = p.x ;
    _f = p.y ;
}