#ifndef ENEMYBEAM_H
#define ENEMYBEAM_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Enemy.h"

// gap from edge of screen
#define GAP 2

/** EnemyBeam Class
 * @brief  Enemy beam in stage one
 * @author Rex Roshan Raj
 */
class EnemyBeam
{

public:

    /** Constructor */
    EnemyBeam();
    
    /** Destructor */
    ~EnemyBeam();

    /** Initialise the parameters for the enemy's beam
    *@param size - size of the beam
    *@param a - x position of the enemy's beam
    *@param b - y position of the enemy's beam
    */
    void init(int size,int a, int b);
    
    /** Updates the beam 
    * @brief Changes the x position of the beam once it has been initialised 
    */ 
    void update();
    
    /** Draws the enemy's beam
    * @param N5110 lcd
    */
    void draw(N5110 &lcd);
    
    /** Gets the position of the enemy's beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos();
    
    /** Sets the position of the enemy's beam 
    *   @brief Position of the enemy's beam
    *   @param position
    */
    void set_pos(Vector2D p);
    
private:

    
    Enemy _e1;
     
    int _speed;
    int _size;
    
    int _x;
    int _y;
    int _a;
    int _b;

};

#endif