#ifndef BACKGROUND_H
#define BACKGROUND_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Background Class
 * @brief  Shows the background of the minigame
 * @author Rex Roshan Raj
 */
class Background
{

public:
    /** Constructor */
    Background();
    
     /** Destructor */    
    ~Background();
    
    /** Initialise the parameters for background in minigame 
    *@param a - x position of the upper cloud
    *@param b - y position of the upper cloud
    */
    void init_u(int a,int b);
    
    /** Initialise the parameters for background in minigame
    *@param c - x position of the lower cloud
    *@param d - y position of the lower cloud
     */
    void init_l(int c, int d);
    
    /** Draws the enemy 
    * @param N5110 lcd
    * @brief Draws the enemy in stage one
    */
    void background(N5110 &lcd);
    
    /** Updates the movement 
    * @brief Changes the y position for animation once the enemy has died 
    */ 
    void update();
    
    /** Gets the position of the upper cloud
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_upper();
    
    /** Gets the position of the lower cloud
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_lower();
    
    /** Sets the position of the upper cloud 
    *   @param position of the upper cloud
    */
    void set_pos_upper(Vector2D e);
    
    /** Sets the position of the lower cloud 
    *   @param position of the lower cloud
    */
    void set_pos_lower(Vector2D e);
    
private:
   
    // methods
    int _a;
    int _b;
    int _c;
    int _d;
    int _fast;

};

#endif