#include "MiniGame.h"

MiniGame::MiniGame()
{

}

MiniGame::~MiniGame()
{

}

// Draws explosion
int explosions [23] [23] = {

{0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
{0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0},
{0,0,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
{0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0},
{0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0},
{0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0},
{0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,1,1,1,0},
{0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0},
{0,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0},
{0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0},
{0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1},
{0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0},
{0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0},
{0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0},
{0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0},
{0,0,1,1,1,1,0,0,0,1,1,1,0,0,0,0,1,1,1,1,0,0,0},
{0,0,0,1,1,1,0,0,1,1,0,1,1,0,0,0,1,1,0,0,0,0,0},
{0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
{0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},

};


void MiniGame::init(int spacecraft_xpos,int spacecraft_ypos,int beam_size,int u_cloudx, int u_cloudy, int l_cloudx, int l_cloudy)
{
    // initialise the game parameters
     _spacecraft_xpos = spacecraft_xpos;
     _spacecraft_ypos = spacecraft_ypos;
     
     _beam_size = beam_size;
     
     _u_cloudx = u_cloudx;
     _u_cloudy = u_cloudy;
     _l_cloudx = l_cloudx;
     _l_cloudy = l_cloudy;
     
     _p1.init(_spacecraft_xpos,_spacecraft_ypos);
     _e1.location();
     _e1.init();
     _b1.init_u(_u_cloudx, _u_cloudy);
     _b1.init_l(_l_cloudx, _l_cloudy);
     _stage = 0;
     _score = 0;
}     

void MiniGame::read_input(Gamepad &pad)
{
    _d = pad.get_direction();                 // Get the direction of the joystick
    _mag = pad.get_mag();                     // Get the magnitude value
    _R = pad.check_event(Gamepad::R_PRESSED); // Check if the R button is being pressed
    _L = pad.check_event(Gamepad::L_PRESSED); // Check if the L button is being pressed
    
}

void MiniGame::draw_minigame(Gamepad &pad,N5110 &lcd)
{
    // draw the background of the game
    _b1.background(lcd);
    
    draw_kills(lcd);
    // player spacecraft
    _p1.character(lcd);
    // first enemy 
    _e1.enemy(lcd);
    // player spacecraft beam
    _beam.draw(lcd);
    
}

void MiniGame::update_minigame(Gamepad &pad,N5110 &lcd)
{
    check_playerbeam_collision(pad); // Check if L/R is being pressed to initiate the player beam
    // it displays the right value
    _p1.update(_d,_mag); // Player spacecraft movement update
    _beam.update();      // Player spacecraft's beam update 
    _e1.update();
    
    _b1.update();       // Background movement update
    
    add_counter();
    add_speed();
    
    check_cloud_wall_collision(pad);
    check_wall_collision(pad);
    
    check_enemy_collisions(pad);      // Check if the player spacecraft beam collides with the enemy spacecraft
    check_player_collision(pad);
    
    // Animations and sound effect for the both the player's and enemy' spacecraft when they are dead
    spacecraft_dead(lcd,pad);
    enemy_dead(lcd,pad);
    draw_kills(lcd);
    
}

void MiniGame::check_playerbeam_collision(Gamepad &pad) // check if player's spacecraft beam has collided with the edges of screen or enemy
{
    Vector2D p1_pos = _p1.get_pos(); // Get player's spacecraft position
    Vector2D beam_pos = _beam.get_pos(); // Get player's spacecraft beam position
    
        if((_R == true)|| (_L == true)){ 
                if ((beam_pos.x + _beam_size > WIDTH) || (spacebeam == true)){ // if hits the enemy or the wall
                _beam.init(_beam_size,p1_pos.x,p1_pos.y);
                _R = false; // Then set the boolean _R and _L to false
                _L = false;
    }
 }
}

void MiniGame::check_player_collision(Gamepad &pad) // check if the player spacecraft has collided with enemy
{
    Vector2D p1_pos = _p1.get_pos(); // Get player's spacecraft position
    Vector2D e1_pos = _e1.get_enemy_pos(); // Get enemy position
    
    if (
        (e1_pos.y >= p1_pos.y) && //top
        (e1_pos.y <= p1_pos.y + 11) && //bottom
        (e1_pos.x >= p1_pos.x) && //left
        (e1_pos.x <= p1_pos.x + 9) 
     ) {
          _stage = 11; 
        }     
     //write new attributes   
     _e1.set_enemy_pos(e1_pos);
}

void MiniGame::check_cloud_wall_collision(Gamepad &pad)
{
    Vector2D upper_pos = _b1.get_pos_upper();
    Vector2D lower_pos = _b1.get_pos_lower();
    
    if (upper_pos.x + 6 >= (WIDTH-1)) {  //  upper cloud // right side
        upper_pos.x = 0;
    }
    else if (lower_pos.x + 6 >= (WIDTH-1) ) { // lower cloud // right side
        lower_pos.x = 0;   
    }
   _b1.set_pos_upper(upper_pos); 
   _b1.set_pos_lower(lower_pos); 
}
    
void MiniGame::check_enemy_collisions(Gamepad &pad)
{
    // read current enemy spacecraft's and player spacecraft's beam attributes
    Vector2D beam_pos = _beam.get_pos();
    Vector2D e1_pos = _e1.get_enemy_pos();

    // see if player's spacecraft beam has hit the enemy's spacecraft by checking for overlaps
    if (
        (beam_pos.y >= e1_pos.y) && //top
        (beam_pos.y <= e1_pos.y + 7) && //bottom
        (beam_pos.x + _beam_size >= e1_pos.x) && //left
        (beam_pos.x + _beam_size <= e1_pos.x + 8)  //right
    ) {
        // add first enemy health
        _e1.add_health();
        spacebeam = true;
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    
    // write new attributes
    _beam.set_pos(beam_pos);
}

void MiniGame::check_wall_collision(Gamepad &pad)
{
       // read current enemy attributes for boss in stage three
    Vector2D e1_pos = _e1.get_enemy_pos();

    // check if hit top wall
    if (e1_pos.y + 6 <= 1) {  //  1 due to 1 pixel boundary
        _e1.location();
    }
    // check if hit bottom wall
    else if (e1_pos.y + 6 >= (HEIGHT-1) ) { // bottom pixel is 47
       _e1.location();
    // check if hit right wall    
    }else if (e1_pos.x + 6 >= (WIDTH-1) ) { // right pixel is 83 
        _e1.location();
    // check if left right wall      
    }else if (e1_pos.x + 6 <= 1) {  // full width
        _e1.location();
    }
    
}

void MiniGame::spacecraft_dead(N5110 &lcd, Gamepad &pad) // animation when the player's spacecraft is dead in stage one
{  
    int p1_health = _p1.get_health(); // Gets the health of the player spacecraft
    Vector2D p1_pos = _p1.get_pos();  // Gets the position of the player's spacecraft
    
    if (_stage == 11){
        
        // explodes and outputs sound if the enemy is dead
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosions);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.5);
        lcd.refresh();
        wait(0.1);
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosions);
        Vector2D v = {p1_pos.x, p1_pos.y};
        while(v.y < 34){
        _p1.update_move();
        v = _p1.get_pos();
        lcd.drawSprite(v.x-5,v.y-7,23,23,(int *)explosions);
        wait(0.1);
        }
        _stage = 12;         // mission one fail
        lcd.refresh();
    }
    
}

void MiniGame::enemy_dead(N5110 &lcd, Gamepad &pad){ // animation when the enemy is dead in stage one

    int e1_health = _e1.get_health();      // Gets the health of the enemy 
    Vector2D e1_pos = _e1.get_enemy_pos(); // Gets the position of the enemy
    
    if (e1_health == 5){ 
       // explodes and outputs sound if the enemy is dead
        _e1.add_score();
        _e1.location();
        _e1.set_health();
         score = true;
    }
    
}


void MiniGame::add_speed()
{
    if ( _counter == 200){
        _e1.add_fast();
        set_counter();
     }   
 }

void MiniGame::draw_kills(N5110 &lcd)
{
    int score = _e1.get_score();
    
    char buffer2[14]; 
    sprintf(buffer2,"%2d",score);
    lcd.printString(buffer2,1,0);
     
}
    
void MiniGame::draw_score(N5110 &lcd)
{
    int i = _e1.get_score();
    
    if (i <= 5){
        _score = i * 50;
    } else if (i > 5 && i <= 10){
        _score = 250 + (i - 5) * 75;
    } else if (i > 10 && i <= 15){
        _score = 625 + (i - 10) * 100;
    } else if (i > 15 && i <= 20){
        _score = 1125 + (i - 15) * 125;
    } else if (i > 20 && i <= 25){
        _score = 1750 + (i - 20) * 150;
    } else if (i > 25 && i <= 30){
        _score = 2500 + (i - 25) * 175;
    } else if (i > 30){
        _score = 3375 + (i - 30) * 200;
    }
        
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",_score);
    lcd.printString("Score: ",8,5);
    lcd.printString(buffer1,WIDTH/2 + 5,5);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
}

int MiniGame::get_game_stage() {
    int stage = _stage;
    return stage;    // Gets the value of the stage
}

void MiniGame::add_counter() {
    
    _counter ++; 
}    
int MiniGame::get_counter() {
    
    int counter = _counter;
    return counter;
    
}    

int MiniGame::set_counter() {
    
    _counter = 0;
    return _counter;

}    
        