#ifndef INSTRUCTION_H
#define INSTRUCTION_H

#include "Gamepad.h"
#include "N5110.h"
#include "mbed.h"

/** Instruction Class
 * @brief  Instruction and Game Rules page
 * @author Rex Roshan Raj
 */
class Instruction
{

public:

    /** Constructor */
    Instruction();
    
    /** Destructor */
    ~Instruction();

    /** Draws instruction
    * @param N5110 lcd
    * @param Gamepad pad
    * @brief Draws all the instruction and the rules of the game
    */
    void rules(N5110 &lcd,Gamepad &pad);
    
    /** Draws guidelines
    * @param N5110 lcd
    * @param Gamepad pad
    * @brief Draws all the guidelines for the minigame
    */
    void mini_rules(N5110 &lcd,Gamepad &pad);
    
    
private:

};

#endif