#ifndef ENEMYBEAM3_H
#define ENEMYBEAM3_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Spacecraft.h"
#include "EnemyBoss.h"

// gap from edge of screen
#define GAP 2

/** EnemyBeam3 Class
 * @brief  Enemy beam in stage three
 * @author Rex Roshan Raj
 */
class EnemyBeam3
{

public:

    /** Constructor */
    EnemyBeam3();
    
    /** Destructor */
    ~EnemyBeam3();

    /** Initialise the parameters for the enemy's beam in stage three
    *@param size - size of the beam
    *@param a - x position of the boss beam
    *@param b - y position of the boss beam
    *@param c - x position of the first enemy's beam
    *@param d - y position of the first enemy's beam
    *@param e - x position of the second enemy's beam
    *@param f - y position of the second enemy's beam
    */
    void init(int size,int a, int b, int c, int d,int e, int f);
    
    /** Updates the beam 
    * @brief Changes the x position of all the enemies beam once it has been initialised 
    */ 
    void update();
    
    /** Draws the enemy's beam
    * @brief Draws all three enemies
    * @param N5110 lcd
    */
    void draw(N5110 &lcd);
    
    /** Gets the position of the enemy's beam
    * @brief Position of the boss beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_boss();
    
    /** Gets the position of the enemy's beam
    * @brief Position of the first enemy beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_enemy1();
    
    /** Gets the position of the enemy's beam
    * @brief Position of the second enemy beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_enemy2();
    
    /** Sets the position of the enemy's beam 
    *   @brief Position of the boss beam
    *   @param position
    */
    void set_pos_boss(Vector2D p);
    
    /** Sets the position of the enemy's beam 
    *   @brief Position of the first enemy's beam
    *   @param position
    */
    void set_pos_enemy1(Vector2D p);
    
    /** Sets the position of the enemy's beam 
    *   @brief Position of the second enemy's beam
    *   @param position
    */
    void set_pos_enemy2(Vector2D p);
    
private:

    Spacecraft _p1;
    EnemyBoss _e3;
     
    int _speed;
    int _size;
    
    int _x;
    int _y;
    int _a;
    int _b;
    int _c;
    int _d;
    int _e;
    int _f;

};

#endif