#ifndef ENEMYBEAM2_H
#define ENEMYBEAM2_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Enemy21.h"
#include "Enemy22.h"

// gap from edge of screen
#define GAP 2

/** EnemyBeam2 Class
 * @brief  Enemy beam in stage two
 * @author Rex Roshan Raj
 */
class EnemyBeam2
{

public:

    /** Constructor */
    EnemyBeam2();
    
    /** Destructor */
    ~EnemyBeam2();

    /** Initialise the parameters for the enemy's beam
    *@param size - size of the beam
    *@param a - x position of the first enemy's beam
    *@param b - y position of the first enemy's beam
    *@param c - x position of the second enemy's beam
    *@param d - y position of the second enemy's beam
    */
    void init(int size,int a, int b, int c, int d);
    
    /** Updates the beam 
    * @brief Changes the x position of the first and second enemy beam once it has been initialised 
    */ 
    void update();
    
    /** Draws the enemy's beam
    * @brief Draws both beams for first and second enemy
    * @param N5110 lcd
    */
    void draw(N5110 &lcd);
    
    /** Gets the position of the enemy's beam
    * @brief Position of the first enemy beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_21();
    
    /** Gets the position of the enemy's beam
    * @brief Position of the second enemy beam
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_pos_22();
    
     /** Sets the position of the enemy's beam 
    *   @brief Position of the first enemy's beam
    *   @param position
    */
    void set_pos_21(Vector2D p);
    
     /** Sets the position of the enemy's beam 
    *   @brief Position of the second enemy's beam
    *   @param position
    */
    void set_pos_22(Vector2D p);
    
private:

    
    Enemy21 _e21;
    Enemy22 _e22;
     
    int _speed;
    int _size;
    
    int _x;
    int _y;
    int _a;
    int _b;
    int _c;
    int _d;

};

#endif