#include "EnemyBeam2.h"

EnemyBeam2::EnemyBeam2()
{

}

EnemyBeam2::~EnemyBeam2()
{

}

void EnemyBeam2::init(int size,int a, int b ,int c, int d) // initialising beam for the first and second enemy in the second stage
{
    _size = size;   // size of the beam
    _x = _size;     // length of the beam
    _y = _size;     // height of the beam
    _a = a;         // x position of the first enemy beam
    _b = b + 5;     // y position of the first enemy beam
    _c = c;         // x position of the second enemy beam
    _d = d;         // y position of the second enemy beam
}

void EnemyBeam2::draw(N5110 &lcd)
{
    // draws the first enemy beam of the second stage
    lcd.drawRect(_a,_b,_x,_y,FILL_BLACK);
    // draws the second enemy beam of the second stage 
    lcd.drawRect(_c,_d,_x,_y,FILL_BLACK);
}

void EnemyBeam2::update()
{
    _speed = 5.0;  // the speed of the beam moving is set at 5

    _a-=_speed;   // moves the first enemy beam in the negative x direction
    _c-=_speed;   // moves the second enemy beam in the negative x direction
    
    // the y direction is kept constant
    
}

Vector2D EnemyBeam2::get_pos_21()
{
    // gets the position of the first enemy beam
    Vector2D b = {_a,_b};
    return b;
}

Vector2D EnemyBeam2::get_pos_22()
{
    // gets the position of the second enemy beam
    Vector2D c = {_c,_d};
    return c;
}

void EnemyBeam2::set_pos_21(Vector2D p)
{
    // sets the position of the first enemy beam
    _a = p.x ;
    _b = p.y ;
}

void EnemyBeam2::set_pos_22(Vector2D p)
{
    // sets the position of the second enemy beam
    _c = p.x ;
    _d = p.y ;
}