#include "GameEngine.h"

GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}

// draws the background of the game
int backgrounds [48][84] = {
    
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},

};

// draws alphabet r in morse code
int r [3][13] = {
    
{0,1,0,0,0,0,0,0,0,0,0,1,0},
{1,1,1,0,0,0,0,0,0,0,1,1,1},
{0,1,0,0,1,1,1,1,1,0,0,1,0},

};

// draws alphabet e in morse code
int e [3][3] = {
    
{0,1,0},
{1,1,1},
{0,1,0},

};

// draws alphabet x in morse code
int x [3][19] = {
    
{0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0},
{0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0},
{1,1,1,1,1,0,0,1,0,0,0,1,0,0,1,1,1,1,1},

};

// draws explosion 
int explosion [23] [23] = {

{0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
{0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0},
{0,0,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
{0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0},
{0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0},
{0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0},
{0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,1,1,1,0},
{0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0},
{0,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0},
{0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0},
{0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1},
{0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0},
{0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0},
{0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0},
{0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0},
{0,0,1,1,1,1,0,0,0,1,1,1,0,0,0,0,1,1,1,1,0,0,0},
{0,0,0,1,1,1,0,0,1,1,0,1,1,0,0,0,1,1,0,0,0,0,0},
{0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
{0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},

};

void GameEngine::init(int spacecraft_xpos,int spacecraft_ypos,int enemy_xpos, int enemy_ypos,int enemy2_xpos, int enemy2_ypos,int enemy3_xpos, int enemy3_ypos,int beam_size,int beam2_size, int speed)
{
     // initialise the game parameters
     _spacecraft_xpos = spacecraft_xpos;
     _spacecraft_ypos = spacecraft_ypos;
    
     _enemy_xpos = enemy_xpos;
     _enemy_ypos = enemy_ypos;
    
     _enemy2_xpos = enemy2_xpos;
     _enemy2_ypos = enemy2_ypos;
    
     _enemy3_xpos = enemy3_xpos;
     _enemy3_ypos = enemy3_ypos;
  
    
     _beam_size = beam_size;    // beam size for 1st and 3rd enemy
     _beam2_size = beam2_size;  // beam size for 2nd enemy
     _speed = speed;            // Speed of the enemy travelling
    
    
     _p1x = GAP;
    // x position on screen - WIDTH is defined in N5110.h
     _e1a = WIDTH-_enemy_xpos;    //enemy_xpos = 12
     // y position on screen - HEIGHT is defined in N5110.h
     _e1b = HEIGHT/2-_enemy_ypos; //enemy_ypos = 4  
     
     _e2a = WIDTH-_enemy2_xpos;       //enemy2_xpos = 12
     _e21b = HEIGHT/2 +_enemy2_ypos;  //enemy2_ypos = 10
     _e22b = HEIGHT/2 -_enemy2_ypos;
     
     _e3a = WIDTH-_enemy3_xpos;       //enemy3_xpos = 20
     _e3b = HEIGHT/2 -_enemy3_ypos;   //enemy3_ypos = 7
     _e3c = WIDTH-_enemy3_xpos - 12;
     _e3d = HEIGHT/2 + _enemy3_ypos;;
     _e3f = HEIGHT/2 - _enemy3_ypos;;
     
     // Initialising the player's spacecraft and all enemy spacecrafts
     _p1.init(_spacecraft_xpos,_spacecraft_ypos);
     _e1.init(_e1a,_e1b);
     _e21.init(_e2a,_e21b,_speed);
     _e22.init(_e2a,_e22b,_speed);
     _e3.init(_e3a,_e3b,_e3c,_e3d,_e3c,_e3f,_speed); 
     _e3.motion();
     
     //_beam.init(_beam_size,p1_pos.x,p1_pos.y);
     // Initialising the stage of the game
     _stage = 0; 

}

void GameEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();                 // Get the direction of the joystick
    _mag = pad.get_mag();                     // Get the magnitude value
    _R = pad.check_event(Gamepad::R_PRESSED); // Check if the R button is being pressed
    _L = pad.check_event(Gamepad::L_PRESSED); // Check if the L button is being pressed
    
}

void GameEngine::draw_mission_one(Gamepad &pad,N5110 &lcd)
{
    // draw the background of the game
    lcd.drawSprite(0,0,48,84,(int *)backgrounds);
    // draw the easter egg of the game
    lcd.drawSprite(6,4,3,13,(int *)r);
    //health
    draw_enemy_health(lcd);
    draw_spacecraft_health(pad);
    // player spacecraft
    _p1.character(lcd);
    // first enemy 
    _e1.enemy(lcd);
    // player spacecraft beam
    _beam.draw(lcd);
    // enemy spacecraft beam
    _enemybeam.draw(lcd);
    
}
void GameEngine::draw_mission_two(Gamepad &pad,N5110 &lcd)
{
    // draw the background of the game
    lcd.drawSprite(0,0,48,84,(int *)backgrounds);
    // draw the easter egg of the game
    lcd.drawSprite(6,4,3,3,(int *)e);
    //health
    draw_spacecraft_health(pad);
    draw_enemy21_health(lcd);
    draw_enemy22_health(lcd);
    // player spacecraft
    _p1.character(lcd);
    // second enemy 
    _e21.enemy2(lcd);
    _e22.enemy2(lcd);
    // player spacecraft beam
    _beam.draw(lcd);
    // second enemy spacecraft beam
    _enemybeam2.draw(lcd);
    
} 

void GameEngine::draw_mission_three(Gamepad &pad,N5110 &lcd)
{
    // draw the background of the game
    lcd.drawSprite(0,0,48,84,(int *)backgrounds);
    // draw the easter egg of the game
    lcd.drawSprite(6,4,3,19,(int *)x);
    //health
    draw_spacecraft_health(pad);
    draw_enemyboss_health(lcd);
    // player spacecraft
    _p1.character(lcd);
    // third and final enemy 
    _e3.enemyboss(lcd);
    // player spacecraft beam
    _beam.draw(lcd);
    // third enemy spacecraft beam
    _enemybeam3.draw(lcd);
    
}

void GameEngine::update_mission_one(Gamepad &pad,N5110 &lcd)
{
    check_playerbeam_collision(pad); // Check if L/R is being pressed to initiate the player beam
    check_enemybeam_collisions(pad); // Check if first enemy's beam has passed the wall to initiate a new beam
    // updating spacecraft and enemy before checking collisions so that
    // it displays the right value
    _p1.update(_d,_mag); // Player spacecraft movement update
    _beam.update();      // Player spacecraft's beam update 
    
    // The enemy spacecraft is stationery in mission one 
    _enemybeam.update(); // Enemy spacecraft's beam update 
    
    check_enemy_collisions(pad);      // Check if the player spacecraft beam collides with the enemy spacecraft
    check_spacecraft_collisions(pad); // Check if the enemy spacecraft beam collides with the player spacecraft
    
    // Animations and sound effect for the both the player's and enemy' spacecraft when they are dead
    spacecraft_dead(lcd,pad);
    enemy_dead(lcd,pad);
    
}

void GameEngine::update_mission_two(Gamepad &pad,N5110 &lcd)
{
    check_playerbeam_collision(pad);  // Check if L/R is being pressed to initiate the player beam
    check_enemybeam2_collisions(pad); // Check if first enemy's beam has passed the wall to initiate a new beam
    // updating spacecraft and enemy before checking collisions so that
    // it displays the right value
    _p1.update(_d,_mag);  // Player spacecraft movement update
    _beam.update();       // Player spacecraft's beam update
    
    _enemybeam2.update(); // Enemy spacecraft's beam update
    _e21.update();        // Second-one enemy spacecraft movement update
    _e22.update();        // Second-two enemy spacecraft movement update
    
    check_enemy2_collisions(pad); // Check if the player spacecraft beam collides with the enemy spacecraft
    check_spacecraft2_collisions(pad); // Check if the enemy spacecraft beam collides with the player spacecraft
    check_wall_collisions(pad);   // Check if enemy spacecraft hits the top and bottom wall to bounce off
    
    // Animations and sound effect for the both the player's and enemy' spacecraft when they are dead
    spacecraft2_dead(lcd,pad);
    enemy2_dead(lcd,pad);

}

void GameEngine::update_mission_three(Gamepad &pad,N5110 &lcd)
{
    check_playerbeam_collision(pad);
    check_enemybeam3_collisions(pad);
  
    _p1.update(_d,_mag);                // Player spacecraft movement update
    _beam.update();                     // Player spacecraft beam update
    _enemybeam3.update();               // Third enemy's spacecraft's beam update
    //_e3.motion();
    _e3.update();                       // Third enemy spacecraft movement update
    check_enemy3_collisions(pad);       // Check if the player spacecraft beam collides with the third enemy spacecraft
    check_spacecraft3_collisions(pad);  // Check if the third enemy spacecraft beam collides with the player spacecraft
    check_wall2_collisions(pad); // Check if enemy spacecraft hits the top,bottom, wall to bounce off
    // Animations and sound effect for the both the player's and enemy' spacecraft
    spacecraft3_dead(lcd,pad);
    enemy3_dead(lcd,pad);

}
void GameEngine::check_enemy_collisions(Gamepad &pad)
{
    // read current enemy spacecraft's and player spacecraft's beam attributes
    Vector2D beam_pos = _beam.get_pos();
    Vector2D e1_pos = _e1.get_enemy_pos();

    // see if player's spacecraft beam has hit the enemy's spacecraft by checking for overlaps
    if (
        (beam_pos.y >= e1_pos.y) && //top
        (beam_pos.y <= e1_pos.y + 7) && //bottom
        (beam_pos.x + _beam_size >= _e1a) && //left
        (beam_pos.x + _beam_size <= _e1a + 8)  //right
    ) {
        // add first enemy health
        _e1.add_health();
        spacebeam = true;
        _e1.location();
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    
    // write new attributes
    _beam.set_pos(beam_pos);
}

void GameEngine::check_enemy2_collisions(Gamepad &pad)
{
    // read curent player spacecraft's beam attributes
    Vector2D beam_pos = _beam.get_pos();
    // check e21 first
    Vector2D e21_pos = _e21.get_enemy21_pos();
    
    // see if player's spacecraft beam has hit the enemy's spacecraft by checking for overlaps
    if (
        (beam_pos.y >= e21_pos.y) && //top
        (beam_pos.y <= e21_pos.y + 7) && //bottom
        (beam_pos.x + _beam_size >= _e2a) && //left
        (beam_pos.x + _beam_size <= _e2a + 7)  //right
    ) {
        // add health to first second level enemy
        _e21.add_health();
        // set boolean spacebeam true
        spacebeam = true;
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    // check e22 next
    Vector2D e22_pos = _e22.get_enemy22_pos();
    
    if (
        (beam_pos.y >= e22_pos.y) && //top
        (beam_pos.y <= e22_pos.y + 7) && //bottom
        (beam_pos.x + _beam_size >= _e2a) && //left
        (beam_pos.x + _beam_size <= _e2a + 7)  //right
    ) {
        // add health to second, second level enemy
        _e22.add_health();
        // set boolean spacebeam true
        spacebeam = true;
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    
    // write new attributes
    _beam.set_pos(beam_pos);
}

void GameEngine::check_enemy3_collisions(Gamepad &pad)
{
    // read curent player's spacecraft beam attributes
    Vector2D beam_pos = _beam.get_pos();
    
    // check e3boss first
    Vector2D e3boss_pos = _e3.get_enemyboss_pos();
    
    // see if player's spacecraft beam has hit the enemy's spacecraft by checking for overlaps
    if (
        (beam_pos.y >= e3boss_pos.y) && //top
        (beam_pos.y <= e3boss_pos.y + 12) && //bottom
        (beam_pos.x + _beam_size >= _e3a) && //left
        (beam_pos.x + _beam_size <= _e3a + 12)  //right
    ) {
        // add health to enemy boss
        _e3.add_health_boss();
        // set boolean spacebeam true
        spacebeam = true;
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    // check e3enemy1 next
    Vector2D e3enemy1_pos = _e3.get_enemy1_pos();
    
    if (
        (beam_pos.y >= e3enemy1_pos.y) && //top
        (beam_pos.y <= e3enemy1_pos.y + 6) && //bottom
        (beam_pos.x + _beam_size >= _e3c) && //left
        (beam_pos.x + _beam_size <= _e3c + 7)  //right
    ) {
        // add health to first third level enemy
        _e3.add_health_enemy1();
        // set boolean spacebeam true
        spacebeam = true;
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    // check e3enemy2 next
    Vector2D e3enemy2_pos = _e3.get_enemy2_pos();
    
    if (
        (beam_pos.y >= e3enemy2_pos.y) && //top
        (beam_pos.y <= e3enemy2_pos.y + 6) && //bottom
        (beam_pos.x + _beam_size >= _e3c) && //left
        (beam_pos.x + _beam_size <= _e3c + 7)  //right
    ) {
        // add health to second third level enemy
        _e3.add_health_enemy2();
        // set boolean spacebeam true
        spacebeam = true;
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    // write new attributes
    _beam.set_pos(beam_pos);
}

void GameEngine::check_playerbeam_collision(Gamepad &pad) // check if player's spacecraft beam has collided with the edges of screen or enemy
{
    Vector2D p1_pos = _p1.get_pos(); // Get player's spacecraft position
    Vector2D beam_pos = _beam.get_pos(); // Get player's spacecraft beam position
    
        if((_R == true)|| (_L == true)){ 
                if ((beam_pos.x + _beam_size > WIDTH) || (spacebeam == true)){ // if hits the enemy or the wall
                _beam.init(_beam_size,p1_pos.x,p1_pos.y);
                _R = false; // Then set the boolean _R and _L to false
                _L = false;
    }
}
}

void GameEngine::check_enemybeam_collisions(Gamepad &pad) // check if enemy beam has collided with the edges of screen or spacecraft in stage one
{
    Vector2D enemy_pos = _e1.get_enemy_pos(); // Position of the first enemy
    Vector2D enemybeam_pos = _enemybeam.get_pos(); // Get first enemy's beam position

    if ((_ebeam == true)||(enemybeam_pos.x - _beam_size < 0)) { // if hits the speacecraft or the wall
    _enemybeam.init(_beam_size,enemy_pos.x,enemy_pos.y); // Initialise the enemy beam in stage one
    _ebeam = false; // Then set the boolean _ebeam to false
    }
}

void GameEngine::check_enemybeam2_collisions(Gamepad &pad) // check if enemy beam has collided with the edges of screen or spacecraft in stage two
{
    Vector2D enemy21_pos = _e21.get_enemy21_pos(); // Get first enemy's position in stage two
    Vector2D enemy22_pos = _e22.get_enemy22_pos(); // Get second enemy's position in stage two
    Vector2D enemybeam21_pos = _enemybeam2.get_pos_21(); // Get first enemy's beam position in stage two
    Vector2D enemybeam22_pos = _enemybeam2.get_pos_22(); // Get second enemy's beam position in stage two
   
    if ((_ebeam21 == true)||(_ebeam22 == true)||(enemybeam21_pos.x - _beam2_size < 0)||(enemybeam22_pos.x - _beam2_size < 0)) {  // if hits the speacecraft or the wall
    _enemybeam2.init(_beam2_size,enemy21_pos.x,enemy21_pos.y,enemy22_pos.x,enemy22_pos.y); // Initialise the enemy beam in stage two
    _ebeam21 = false; // Then set the boolean _ebeam21 and _ebeam22 to false
    _ebeam22 = false;
    }
}

void GameEngine::check_enemybeam3_collisions(Gamepad &pad) // check if enemy beam has collided with the edges of screen or spacecraft in stage three
{
    Vector2D enemyboss_pos = _e3.get_enemyboss_pos(); // Get boss enemy's position in stage three
    Vector2D enemy1_pos = _e3.get_enemy1_pos(); // Get first regular enemy's position in stage three
    Vector2D enemy2_pos = _e3.get_enemy2_pos(); // Get second regular enemy's position in stage three
    
    Vector2D enemybossbeam3_pos = _enemybeam3.get_pos_boss(); // Get boss enemy's beam position in stage three
    Vector2D enemy1beam3_pos = _enemybeam3.get_pos_enemy1(); // Get first regular enemy's beam position in stage three
    Vector2D enemy2beam3_pos = _enemybeam3.get_pos_enemy2(); // Get second regular enemy's beam position in stage three
    
    if ((_ebeam3boss == true)||(_ebeam31 == true)||(_ebeam32 == true)||(enemybossbeam3_pos.x - _beam_size < 0)||(enemy1beam3_pos.x - _beam_size < 0)||(enemy2beam3_pos.x - _beam_size < 0)) { // if hits the speacecraft or the wall
    _enemybeam3.init(_beam_size,enemyboss_pos.x,enemyboss_pos.y,enemy1_pos.x,enemy1_pos.y,enemy2_pos.x,enemy2_pos.y);  // Initialise the enemy beam in stage three
    _ebeam3boss = false; // Then set boolean _ebeam3boss,_ebeam31, _ebeam32 to false
    _ebeam31 = false;
    _ebeam32 = false;
    }
}

void GameEngine::check_spacecraft_collisions(Gamepad &pad) // check spacecraft collision with enemy beam in stage one
{
    Vector2D enemybeam_pos = _enemybeam.get_pos(); // Gets the position of the enemy's beam in stage one
    Vector2D p1_pos = _p1.get_pos();               // Gets the position of the player's spacecraft

     // see if beam has hit the enemy by checking for overlaps
    if (
        (enemybeam_pos.y >= p1_pos.y) && //top
        (enemybeam_pos.y <= p1_pos.y + 11) && //bottom
        (enemybeam_pos.x >= _p1x) && //left
        (enemybeam_pos.x <= _p1x + 11)  //right
    ) {
        _p1.add_health(); // adds health 
        _ebeam = true;    // sets boolean to true to initialise beam
        pad.tone(87.3,0.1); // outputs sound if it hits the player's spacecraft
    }
    // write new attributes
    _enemybeam.set_pos(enemybeam_pos);
    
}

void GameEngine::check_spacecraft2_collisions(Gamepad &pad) // check spacecraft collision with enemy beam in stage two
{
    Vector2D enemybeam21_pos = _enemybeam2.get_pos_21(); // Gets the position of the first enemy's beam in stage two
    Vector2D enemybeam22_pos = _enemybeam2.get_pos_22(); // Gets the position of the second enemy's beam in stage two
    Vector2D p1_pos = _p1.get_pos(); // Gets the position of the player's spacecraft

     // see if beam has hit the enemy by checking for overlaps
    if (
        (enemybeam21_pos.y >= p1_pos.y) && //top
        (enemybeam21_pos.y <= p1_pos.y + 11) && //bottom
        (enemybeam21_pos.x >= _p1x) && //left
        (enemybeam21_pos.x <= _p1x + 11)  //right
    ) {
        _p1.add_health(); // adds health
        _ebeam21 = true;  // sets boolean to true to initialise beam
        pad.tone(87.3,0.1); // outputs sound if it hits the player's spacecraft
    }
    else if (
        (enemybeam22_pos.y >= p1_pos.y) && //top
        (enemybeam22_pos.y <= p1_pos.y + 11) && //bottom
        (enemybeam22_pos.x >= _p1x) && //left
        (enemybeam22_pos.x <= _p1x + 11)  //right
    ) {
        _p1.add_health(); // adds health
        _ebeam22 = true;  // sets boolean to true to initialise beam
        pad.tone(87.3,0.1); // outputs sound if it hits the player's spacecraft
    }
    // write new attributes
    _enemybeam2.set_pos_21(enemybeam21_pos);
    _enemybeam2.set_pos_22(enemybeam22_pos);
    
}

void GameEngine::check_spacecraft3_collisions(Gamepad &pad) // check spacecraft collision with enemy beam in stage three
{
    Vector2D enemybossbeam_pos = _enemybeam3.get_pos_boss(); // Gets the position of the boss enemy's beam in stage three
    Vector2D enemy1beam_pos = _enemybeam3.get_pos_enemy1();  // Gets the position of the first enemy's beam in stage three
    Vector2D enemy2beam_pos = _enemybeam3.get_pos_enemy2();  // Gets the position of the second enemy's beam in stage three
    
    Vector2D p1_pos = _p1.get_pos(); // Gets the position of the player's spacecraft

     // see if beam has hit the enemy by checking for overlaps
    if (
        (enemybossbeam_pos.y >= p1_pos.y) && //top
        (enemybossbeam_pos.y <= p1_pos.y + 11) && //bottom
        (enemybossbeam_pos.x >= _p1x) && //left
        (enemybossbeam_pos.x <= _p1x + 11)  //right
    ) {
        _p1.add_health();   // adds health
        _ebeam3boss = true; // sets boolean to true to initialise beam
        pad.tone(87.3,0.1);
    }
    else if (
        (enemy1beam_pos.y >= p1_pos.y) && //top
        (enemy1beam_pos.y <= p1_pos.y + 11) && //bottom
        (enemy1beam_pos.x >= _p1x) && //left
        (enemy1beam_pos.x <= _p1x + 11)  //right
    ) {
        _p1.add_health(); // adds health
        _ebeam31 = true;  // sets boolean to true to initialise beam
        pad.tone(87.3,0.1);
    }
    else if (
        (enemy2beam_pos.y >= p1_pos.y) && //top
        (enemy2beam_pos.y <= p1_pos.y + 11) && //bottom
        (enemy2beam_pos.x >= _p1x) && //left
        (enemy2beam_pos.x <= _p1x + 11)  //right
    ) {
        _p1.add_health(); // adds health
        _ebeam32 = true;  // sets boolean to true to initialise beam
        pad.tone(87.3,0.1); // outputs sound if it hits the player's spacecraft
    }
    // write new attributes
    _enemybeam3.set_pos_boss(enemybossbeam_pos);
    _enemybeam3.set_pos_enemy1(enemy1beam_pos);
    _enemybeam3.set_pos_enemy2(enemy2beam_pos);
    
}
void GameEngine::check_wall_collision(Gamepad &pad) // check wall collision for enemy in stage one
{
    // read current enemy attributes for boss in stage three
    Vector2D enemy_pos = _e1.get_enemy_pos();

    // check if hit top wall
    if (enemy_pos.y <= 1) {  //  1 due to 1 pixel boundary
        enemy_pos.y = 1;  // bounce off ceiling without going off screen
    }
    // check if hit bottom wall
    else if (enemy_pos.y + 12 >= (HEIGHT-1) ) { // bottom pixel is 47
       enemy_pos.y = (HEIGHT-1) - 12;  // stops ball going off screen
    // check if hit right wall    
    }else if (enemy_pos.x + 12 >= (WIDTH-1) ) { // right pixel is 83 
        enemy_pos.x = (WIDTH-1) - 12;  // stops ball going off screen
    // check if left right wall      
    }else if (enemy_pos.x <= WIDTH/2) {  // half the width (42)
        enemy_pos.x = WIDTH/2;  // bounce off ceiling without going halfway
    }
    _e1.set_enemy_pos(enemy_pos);
    
}
    
void GameEngine::check_wall_collisions(Gamepad &pad) // check wall collision for enemies in stage two
{
    // read current attributes of the enemies 
    Vector2D enemy21_pos = _e21.get_enemy21_pos();
    Vector2D enemy22_pos = _e22.get_enemy22_pos();
    Vector2D enemy21_movement = _e21.get_movement();
    Vector2D enemy22_movement = _e22.get_movement();

    // check if hit top wall
    // first enemy
    if (enemy21_pos.y <= 1) {  //  1 due to 1 pixel boundary
        enemy21_pos.y = 1;  // bounce off ceiling without going off screen
        enemy21_movement.y = -enemy21_movement.y;
    }
    //second enemy
    else if (enemy22_pos.y <= 1) { 
        enemy22_pos.y = 1; 
        enemy22_movement.y = -enemy22_movement.y;
    }
    // check if hit bottom wall
    // first enemy
    else if (enemy21_pos.y + 7 >= (HEIGHT-1) ) { // bottom pixel is 47
        enemy21_pos.y = (HEIGHT-1) - 7;  // stops ball going off screen
        enemy21_movement.y = -enemy21_movement.y;
    // second enemy    
    } else if (enemy22_pos.y + 7 >= (HEIGHT-1) ) { 
        enemy22_pos.y = (HEIGHT-1) - 7;  
        enemy22_movement.y = -enemy22_movement.y;
        
    } 

    // update first and second enemy parameters
    _e21.set_movement(enemy21_movement);
    _e22.set_movement(enemy22_movement);
    _e21.set_enemy21_pos(enemy21_pos);
    _e22.set_enemy22_pos(enemy22_pos);
}

void GameEngine::check_wall2_collisions(Gamepad &pad) // check wall collision for enemies in stage three
{
    // read current enemy attributes for boss in stage three
    Vector2D enemyboss_pos = _e3.get_enemyboss_pos();
    Vector2D enemyboss_movement = _e3.get_movement();

    // check if hit top wall
    if (enemyboss_pos.y <= 1) {  //  1 due to 1 pixel boundary
        enemyboss_pos.y = 1;  // bounce off ceiling without going off screen
        enemyboss_movement = _e3.motion();
    }
    // check if hit bottom wall
    else if (enemyboss_pos.y + 12 >= (HEIGHT-1) ) { // bottom pixel is 47
        enemyboss_pos.y = (HEIGHT-1) - 12;  // stops ball going off screen
        enemyboss_movement = _e3.motion();
    // check if hit right wall    
    }else if (enemyboss_pos.x + 12 >= (WIDTH-1) ) { // right pixel is 83 
        enemyboss_pos.x = (WIDTH-1) - 12;  // stops ball going off screen
        enemyboss_movement = _e3.motion();
    // check if left right wall      
    }else if (enemyboss_pos.x <= WIDTH/2) {  // half the width (42)
        enemyboss_pos.x = WIDTH/2;  // bounce off ceiling without going halfway
        enemyboss_movement = _e3.motion();
    }
    // update boss enemy parameters
    _e3.set_movement(enemyboss_movement);
    _e3.set_enemyboss_pos(enemyboss_pos);
    
}

void GameEngine::enemy_dead(N5110 &lcd, Gamepad &pad){ // animation when the enemy is dead in stage one

    int e1_health = _e1.get_health();      // Gets the health of the enemy 
    Vector2D e1_pos = _e1.get_enemy_pos(); // Gets the position of the enemy
    
    if (e1_health == 10){ 
       // explodes and outputs sound if the enemy is dead
        lcd.drawSprite(e1_pos.x-10,e1_pos.y-10,23,23,(int *)explosion);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.5);
        _e1.update();
        lcd.drawSprite(e1_pos.x-10,e1_pos.y-10,23,23,(int *)explosion);
        _stage = 2;  // mission one pass
        lcd.refresh();
    }
    
}

void GameEngine::enemy2_dead(N5110 &lcd, Gamepad &pad){ // animation when the enemy is dead in stage two
    
    int e21_health = _e21.get_health();    // Gets the health of the first enemy
    int e22_health = _e22.get_health();    // Gets the health of the second enemy
    
    Vector2D e21_pos = _e21.get_enemy21_pos(); // Gets the position of the first enemy
    Vector2D e22_pos = _e22.get_enemy22_pos(); // Gets the position of the second enemy
    
    if ((e21_health >= 10) && (e22_health >= 10)){ 
    // explodes and outputs sound if the enemy is dead
        lcd.drawSprite(e21_pos.x-10,e21_pos.y-10,23,23,(int *)explosion);
        lcd.drawSprite(e22_pos.x-10,e22_pos.y-10,23,23,(int *)explosion);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.2);
        lcd.drawSprite(e21_pos.x-10,e21_pos.y-10,23,23,(int *)explosion);
        lcd.drawSprite(e22_pos.x-10,e22_pos.y-10,23,23,(int *)explosion);
        _stage = 4;    // mission two pass
        lcd.refresh();
    }
    
}

void GameEngine::enemy3_dead(N5110 &lcd, Gamepad &pad){ // animation when the enemy is dead in stage three
    
    int e3boss_health = _e3.get_health_boss();  // Gets the health of the boss enemy
    int e31_health = _e3.get_health_enemy1();   // Gets the health of the first enemy
    int e32_health = _e3.get_health_enemy2();   // Gets the health of the second enemy
    
    Vector2D e3boss_pos = _e3.get_enemyboss_pos(); // Gets the position of the boss enemy
    Vector2D e31_pos = _e3.get_enemy1_pos();       // Gets the position of the first enemy
    Vector2D e32_pos = _e3.get_enemy2_pos();       // Gets the position of the second enemy
    
    // explodes and outputs sound if the enemy is dead
    if ((e3boss_health >= 10) && (e31_health >= 10) && (e32_health >= 10)){
        lcd.drawSprite(e3boss_pos.x-10,e3boss_pos.y-10,23,23,(int *)explosion);
        lcd.drawSprite(e31_pos.x-10,e31_pos.y-10,23,23,(int *)explosion);
        lcd.drawSprite(e32_pos.x-10,e32_pos.y-10,23,23,(int *)explosion);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.2);
        lcd.drawSprite(e3boss_pos.x-10,e3boss_pos.y-10,23,23,(int *)explosion);
        lcd.drawSprite(e31_pos.x-10,e31_pos.y-10,23,23,(int *)explosion);
        lcd.drawSprite(e32_pos.x-10,e32_pos.y-10,23,23,(int *)explosion);
        _stage = 6;   // mission three pass
        lcd.refresh();
    }
    
}

void GameEngine::spacecraft_dead(N5110 &lcd, Gamepad &pad) // animation when the player's spacecraft is dead in stage one
{  
    int p1_health = _p1.get_health(); // Gets the health of the player spacecraft
    Vector2D p1_pos = _p1.get_pos();  // Gets the position of the player's spacecraft
    
    if (p1_health == 6){
        
        // explodes and outputs sound if the enemy is dead
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosion);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.5);
        lcd.refresh();
        wait(0.1);
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosion);
        _p1.update_move();
        _stage = 1;         // mission one fail
        lcd.refresh();
    }
    
}

void GameEngine::spacecraft2_dead(N5110 &lcd, Gamepad &pad) // animation when the player's spacecraft is dead in stage two
{
   
    int p1_health = _p1.get_health(); // Gets the health of the player spacecraft
    Vector2D p1_pos = _p1.get_pos();  // Gets the position of the player's spacecraft
    
    if (p1_health == 6){
        
        // explodes and outputs sound if the enemy is dead
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosion);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.5);
        lcd.refresh();
        wait(0.1);
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosion);
        _p1.update_move();
        _stage = 3;   // mission two fail
        lcd.refresh();
    }
    
}

void GameEngine::spacecraft3_dead(N5110 &lcd, Gamepad &pad) // animation when the player's spacecraft is dead in stage three
{
    int p1_health = _p1.get_health(); // Gets the health of the player spacecraft
    Vector2D p1_pos = _p1.get_pos();  // Gets the position of the player's spacecraft
    
    if (p1_health == 6){
        
        // explodes and outputs sound if the enemy is dead
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosion);
        pad.tone(1000.0,0.5);
        pad.tone(800.0,0.5);
        pad.tone(600.0,0.5);
        pad.tone(400.0,0.5);
        wait(0.5);
        lcd.refresh();
        wait(0.1);
        lcd.drawSprite(p1_pos.x-5,p1_pos.y-7,23,23,(int *)explosion);
        _p1.update_move();
        _stage = 5;        // mission three fail
        lcd.refresh();
    }
    
}

void GameEngine::draw_enemy_health(N5110 &lcd)
{
    // get health of the enemy 
    int e1_health = _e1.get_health();
    
    if (e1_health <= 10){
    lcd.drawRect(62,42,20,4,FILL_TRANSPARENT);
    lcd.drawRect(62,42,20-2*e1_health,4,FILL_BLACK);
    }
    else {
    lcd.drawRect(62,42,20,4,FILL_TRANSPARENT);
    }
    
        
}

void GameEngine::draw_enemy21_health(N5110 &lcd)
{
    // get health of the enemy 
    int e21_health = _e21.get_health();
    
    if (e21_health <= 10){
    lcd.drawRect(2,42,20,4,FILL_TRANSPARENT);
    lcd.drawRect(2,42,20-2*e21_health,4,FILL_BLACK);
    }
    else {
    lcd.drawRect(2,42,20,4,FILL_TRANSPARENT);
    }    
}

void GameEngine::draw_enemy22_health(N5110 &lcd)
{
    // get health of the enemy 
    int e22_health = _e22.get_health();
    
    if (e22_health <= 10){
    lcd.drawRect(62,42,20,4,FILL_TRANSPARENT);
    lcd.drawRect(62,42,20-2*e22_health,4,FILL_BLACK);
    }
    else {
    lcd.drawRect(62,42,20,4,FILL_TRANSPARENT);
    } 
        
}

void GameEngine::draw_enemyboss_health(N5110 &lcd)
{
    // get health of the enemy in stage three
    int e3boss_health = _e3.get_health_boss();
    int e3enemy1_health = _e3.get_health_enemy1();
    int e3enemy2_health = _e3.get_health_enemy2();
    
    if (e3boss_health <= 10){ 
    lcd.drawRect(62,42,20,4,FILL_TRANSPARENT);
    lcd.drawRect(62,42,20-2*e3boss_health,4,FILL_BLACK);
    }
    else {
    lcd.drawRect(62,42,20,4,FILL_TRANSPARENT);
    }
    if (e3enemy1_health <= 10){
    lcd.drawRect(2,42,20,4,FILL_TRANSPARENT);
    lcd.drawRect(2,42,20-2*e3enemy1_health,4,FILL_BLACK);
    }
    else {
    lcd.drawRect(2,42,20,4,FILL_TRANSPARENT);
    }    
    if (e3enemy2_health <= 10){
    lcd.drawRect(62,2,20,4,FILL_TRANSPARENT);
    lcd.drawRect(62,2,20-2*e3enemy2_health,4,FILL_BLACK);
    }
    else {
    lcd.drawRect(62,2,20,4,FILL_TRANSPARENT);
    }
}

void GameEngine::draw_spacecraft_health(Gamepad &pad)
{
    //get the health of the spacecraft 
    int p1_health = _p1.get_health();
    
    if (p1_health == 0){ // All the lights are switched on
        pad.leds_on();
        
    }else if (p1_health == 1){ // Switches off the left most light
        pad.led(1,0);
        pad.led(2,1);
        pad.led(3,1);
        pad.led(4,1);
        pad.led(5,1);
        pad.led(6,1);
        
    }else if (p1_health == 2){ // Switches of the two left most lights
        pad.led(1,0);
        pad.led(2,0);
        pad.led(3,1);
        pad.led(4,1);
        pad.led(5,1);
        pad.led(6,1);
    }else if (p1_health == 3){ // Swtiches of the three left most lights
        pad.led(1,0);
        pad.led(2,0);
        pad.led(3,0);
        pad.led(4,1);
        pad.led(5,1);
        pad.led(6,1);
        
    }else if (p1_health == 4){ // Switches off the four left most lights
        pad.led(1,0);
        pad.led(2,0);
        pad.led(3,0);
        pad.led(4,0);
        pad.led(5,1);
        pad.led(6,1);
        
    }else if (p1_health == 5){ // Switches the five left most light
        pad.led(1,0);
        pad.led(2,0);
        pad.led(3,0);
        pad.led(4,0);
        pad.led(5,0);
        pad.led(6,1);
        
    } else {
        pad.leds_off(); // Switches all the Led light off
    }
        
}
        
int GameEngine::get_game_stage() {
    int stage = _stage;
    return stage;    // Gets the value of the stage
}

int GameEngine::restart_game_stage() {
    
    int stage = _stage;
    stage = 0;  // sets the stage to be zero 
    return stage;    
}        