/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Rex Roshan Raj
Username: el17rrs
Student ID Number: 201184290
Start Date: 15/03/2019
End Date: 9/05/2019 
*/

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Instruction.h"
#include "Spacecraft.h"
#include "GameEngine.h"
#include "MiniGame.h"
#include "Solar.h"
#include "Music.h"
#include "rtos.h"

/** @file main.cpp
 *  @brief Contains the main code of the program.
 */
 
// Structs 
struct UserInput {
    Direction d;
    float mag;
};

// enum state for MainPage
enum MainPage { TitleScreen, Menu, Mini_Game, Mission };

// enum state for MiniState
enum MiniState { Dead, Alive };

// enum state for Mission state
enum MissionState {Mission1,Mission1Pass,Mission1Fail,Mission2,Mission2Pass,Mission2Fail,Mission3,Mission3Pass,Mission3Fail,Congratulations };

// Objects
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11); // K64F - pwr from 3V3
Gamepad pad;
Music play;
Instruction instruct;
Thread thread;
Spacecraft game;
GameEngine shoot;
MiniGame mini;


// Prototypes
void init();
void mini_init();
void welcome();
void mini_render();
void render_nothing();
void render();
void render2();
void render3();
void mini_rules();
void intro();
void instruction();

bool end = false;
bool finish = false;
bool music_end = false;


int main()
{
    int fps = 8;          // Set the frames per second = 8
    lcd.setContrast(0.4); // 0.4 appears to be a good starting point
    init();               // Initialise all the parameters in GameEngine
    
    MainPage currentState = TitleScreen;              // Initial state of MainPage
    MissionState currentMission = Mission1;           // Initial state of MissionState 
    MiniState currentMini = Alive;                    // Initial state of MiniState
    
    
     while(1) {
        switch(currentState){
            case TitleScreen:
                // Draws the Title Screen
                lcd.clear();
                lcd.refresh();
                thread.start(welcome);
                intro();
                thread.terminate(); 
                render_nothing();
                wait(1.0f/fps);
                currentState = Menu;
            break;
            case Menu:
                // Draws the Menu Page
                lcd.clear();
                lcd.drawSprite(4,7,9,9, (int*)x_button);
                lcd.drawSprite(4,23,9,9, (int*)y_button);
                lcd.printString("Mission",20,1);
                lcd.printString("Mini Game",20,3);
                lcd.refresh();
                if (pad.check_event(Gamepad::X_PRESSED) == true){
                    currentState = Mission;
                     end = false;
                     // instruction page for the game
                     instruction(); 
                } else if (pad.check_event(Gamepad::Y_PRESSED) == true){
                    currentState = Mini_Game;
                    finish = false;
                    // rules page for the mini game
                    mini_rules();
                }
            break;
            
            case Mission: 
                currentMission = Mission1;
                while(!end){
                    switch(currentMission){
                      // First Mission
                      case Mission1:
                        shoot.read_input(pad);
                        shoot.update_mission_one(pad,lcd);
                        render();
                        wait(1.0f/fps); 
                        if(shoot.get_game_stage() == 1){
                            currentMission = Mission1Fail;
                        break;
                        }
                        else if(shoot.get_game_stage() == 2){
                            currentMission = Mission1Pass;
                            break;
                        }else {
                            currentMission = Mission1;
                        }    
                      break;
                      // Mission One Failed
                      case Mission1Fail:
                        // output the mission fail page
                        lcd.clear();
                        lcd.drawSprite(6,5,42,73,(int *)mission_fail);
                        lcd.drawSprite(51,11,7,19,(int *)m_one);
                        lcd.refresh();
                        // play the mission failure song
                        play.mission_fail(pad);
                        if (pad.check_event(Gamepad::B_PRESSED) == true){
                            currentMission = Mission1;
                            shoot.restart_game_stage();
                            init();
                        }
                      break;
                      case Mission1Pass:
                        // outputs the mission pass page
                        lcd.clear();
                        lcd.drawSprite(0,0,48,84,(int *)mission_pass);
                        lcd.drawSprite(51,11,7,19,(int *)m_one);
                        lcd.refresh();
                        // plays the mission success song
                        play.mission_success(pad);
                        if (pad.check_event(Gamepad::A_PRESSED) == true){
                            currentMission = Mission2;
                            shoot.restart_game_stage();
                            init();
                        }
                      break;
                      // Mission two
                      case Mission2:
                        shoot.read_input(pad);
                        shoot.update_mission_two(pad,lcd);
                        render2();
                        wait(1.0f/fps);
                        if(shoot.get_game_stage() == 3 ){
                            currentMission = Mission2Fail;
                        }
                        if(shoot.get_game_stage() == 4){
                            currentMission = Mission2Pass;
                        }
                      break;
                      case Mission2Fail:
                        // outputs the mission fail page 
                        lcd.clear();
                        lcd.drawSprite(6,5,42,73,(int *)mission_fail);
                        lcd.drawSprite(51,12,5,18,(int *)m_two);
                        lcd.refresh();
                        // play mission failure song
                        play.mission_fail(pad);
                        if (pad.check_event(Gamepad::B_PRESSED) == true){
                            currentMission = Mission1;
                            shoot.restart_game_stage();
                            init();
                        }
                      break;
                      case Mission2Pass:
                        // outputs the mission pass page 
                        lcd.clear();
                        lcd.drawSprite(0,0,48,84,(int *)mission_pass);
                        lcd.drawSprite(51,12,5,18,(int *)m_two);
                        lcd.refresh();
                        // plays the mission success song
                        play.mission_success(pad);
                        if (pad.check_event(Gamepad::A_PRESSED) == true){
                            currentMission = Mission3;
                            shoot.restart_game_stage();
                            init();
                        }
                      break; 
                      // Mission three
                      case Mission3:
                        shoot.read_input(pad);
                        shoot.update_mission_three(pad,lcd);
                        render3();
                        wait(1.0f/fps);
                        if(shoot.get_game_stage() == 5 ){
                            currentMission = Mission3Fail;
                        }
                        if(shoot.get_game_stage() == 6){
                            currentMission = Mission3Pass;
                        }
                      break;
                      case Mission3Fail:
                        // outputs a mission fail page
                        lcd.clear();
                        lcd.drawSprite(6,5,42,73,(int *)mission_fail);
                        lcd.drawSprite(48,12,5,29,(int *)m_three);
                        lcd.refresh();
                        play.mission_fail(pad);
                        if (pad.check_event(Gamepad::B_PRESSED) == true){
                            currentMission = Mission1;
                            shoot.restart_game_stage();
                            init();
                        }
                      break;
                      case Mission3Pass:
                        // outputs a mission pass page
                        lcd.clear();
                        lcd.drawSprite(0,0,48,84,(int *)mission_pass);
                        lcd.drawSprite(48,12,5,29,(int *)m_three);
                        lcd.refresh();
                        play.mission_success(pad);
                        if (pad.check_event(Gamepad::A_PRESSED) == true){
                            currentMission = Congratulations;
                        }
                      break;   
                      case Congratulations:
                        for(int i = 0; i < 3; i++){
                            lcd.clear();
                            lcd.drawSprite(0,0,48,84,(int *) congrats);
                            lcd.drawSprite(0,23,25,84,(int *)party_popper);
                            lcd.refresh();
                            wait(0.5);
                            lcd.clear();
                            lcd.drawSprite(0,0,48,84,(int *) congrats);
                            lcd.refresh();
                            wait(0.5);
                        }
                        while(pad.check_event(Gamepad::A_PRESSED) == false){
                            lcd.clear();
                            lcd.drawSprite(0,0,48,84,(int *) congrats);
                            lcd.drawSprite(25,28,13,36,(int *) exit1);
                            lcd.refresh();
                            if (pad.check_event(Gamepad::A_PRESSED) == true){
                                end = true;
                                music_end = false;
                                break;
                            }
                        }
                      break;
                  }
                }
                currentState = TitleScreen;
            break;

            case Mini_Game:
                mini_init();
                currentMini = Alive;
                   while(!finish) {
                    switch(currentMini){
                        case Alive:
                            mini.read_input(pad);
                            mini.update_minigame(pad,lcd);
                            mini_render();
                            wait(1.0f/fps);  
                            if(mini.get_game_stage() == 12){
                            currentMini = Dead;
                            break;
                            }
                        break;
          
                        case Dead:
                            lcd.clear();
                            lcd.printString("     Your   ",0,1);
                            lcd.printString("  Spacecraft",4,2);
                            lcd.printString("  have fallen",0,3);
                            lcd.drawSprite(72,39,9,9, (int*)x_button); 
                            mini.draw_score(lcd); 
                            lcd.refresh();
                            wait(1.0f/fps); 
                            if (pad.check_event(Gamepad::X_PRESSED) == true){
                                finish = true;
                                music_end = false;
                            }
                        break;
                    }
                }
                currentState = TitleScreen;
              break;  
        }
    }
}

void init()
{
    // need to initialise LCD,Gamepad and the Game
    lcd.init();
    pad.init();
    //Initialise (x pos of player spacecraft, y pos of player spacecraft, x pos of enemy stage 1,y pos of enemy stage 1, x pos of enemy1 stage 2, y pos of enemy1 stage 2, x pos of enemy2 stage 2, y pos of enemy2 stage 2, x pos of boss stage 3, y pos of boss stage 3, beam size 1, beam size 2, motion speed)
    shoot.init(WIDTH/12,HEIGHT/2-5,16,4,12,10,20,11,3,2,4);

}

void mini_init()
{
    // need to initialise LCD,Gamepad and the Game
    lcd.init();
    pad.init();
    //Initialise (x pos of player spacecraft, y pos of player spacecraft, beam size 1)
    mini.init(WIDTH/12,HEIGHT/2-5,3,66,0,36,30);

}


void render()
{
    // clear screen, re-draw and refresh
    // Mission 1
    lcd.clear();  
    shoot.draw_mission_one(pad,lcd);
    lcd.refresh();
}

void render2()
{
    // clear screen, re-draw and refresh
    // Mission 2
    lcd.clear();  
    shoot.draw_mission_two(pad,lcd);
    lcd.refresh();
}

void render3()
{
    // clear screen, re-draw and refresh
    // Mission 3
    lcd.clear();  
    shoot.draw_mission_three(pad,lcd);
    lcd.refresh();
}

void welcome() 
{
     
    // draws the sprites until the Start button is pressed 
    
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        if(pad.check_event(Gamepad::START_PRESSED) == true){break;}
        pad.leds_on();
        lcd.drawSprite(6,0,48,71,(int *)screen);
        lcd.drawSprite(21,43,5,40,(int *)start);
        lcd.refresh();
        Thread::wait(800);
        if(pad.check_event(Gamepad::START_PRESSED) == true){break;}
        pad.leds_off();
        lcd.drawSprite(6,0,48,71,(int *)screen);
        lcd.refresh();
        Thread::wait(800);
        if(pad.check_event(Gamepad::START_PRESSED) == true){break;}

    }
    pad.leds_off();
}

void intro() 
{ 
    //plays the introduction music for game
    play.intro_song(pad);
}
        
void instruction()
{
    // clears, draws the instrcution and game rules page and refreshes the page
    pad.leds_off();
    lcd.clear();
    instruct.rules(lcd,pad);
    lcd.refresh();
    
    
}

void mini_rules()
{
    // clears, draws the mini game rules page and refreshes the page
    lcd.clear();
    instruct.mini_rules(lcd,pad);
    lcd.refresh();
}    
   
void mini_render()
{
    // Mini Game
    // clear screen, re-draw and refresh
    lcd.clear();  
    mini.draw_minigame(pad,lcd);
    lcd.refresh();
}

void render_nothing()
{   
    lcd.clear();  
    lcd.refresh();
}    

