#include "EnemyBoss.h"

// nothing doing in the constructor and destructor
EnemyBoss::EnemyBoss()
{

}

EnemyBoss::~EnemyBoss()
{

}       

// sprite of the third-(one&two) enemy
int enemy2 [7][8] = {
   
{0,1,1,0,0,0,0,1},
{0,0,0,1,1,1,1,1},
{0,0,1,0,0,1,1,0},
{0,1,0,0,1,1,1,0},
{0,0,1,0,0,1,1,0},
{0,0,0,1,1,1,1,1},
{0,1,1,0,0,0,0,1},

};

// sprite of the third-boss enemy
int boss [13][13] = {
    
{0,0,0,0,0,1,1,1,1,1,0,0,0},
{0,0,0,0,0,0,1,1,1,0,0,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,0,1,0,0,1,0,0},
{0,0,0,0,1,0,1,0,1,0,1,0,0},
{0,0,0,1,0,0,0,1,0,1,1,0,0},
{1,1,1,1,0,1,0,1,0,1,1,0,0},
{0,0,0,1,0,0,0,1,0,1,1,0,0},
{0,0,0,0,1,0,1,0,1,0,1,0,0},
{0,0,0,0,0,1,0,1,0,0,1,0,0},
{0,0,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,1,1,1,0,0,0,0},
{0,0,0,0,0,1,1,1,1,1,0,0,0},    

};

void EnemyBoss::init(int a,int b,int c,int d,int e,int f,int speed) // initialising the x and y position of the third enemy and movement speed of the third enemy
{
  
    _a = a; // x position of the boss enemy for stage 3
    _b = b; // y position of the boss enemy for stage 3
    _c = c; // x position of the first regular enemy for stage 3
    _d = d; // y position of the first regular enemy for stage 3
    _e = e; // x position of the second regular enemy for stage 3
    _f = f; // y position of the second regular enemy for stage 3
    
    _health = 0;  // start health from zero for boss
    _health1 = 0; // start health from zero for first enemy
    _health2 = 0; // start health from zero for second enemy
    
    _speed = speed;

}

Vector2D EnemyBoss::motion()
{
    int direction = rand() % 8; // randomise initial direction. 
    
    // 8 possibilities. Get random modulo and set movement accordingly
    if (direction == 0) {        // North
        _movement.x = 0;
        _movement.y = -_speed; 
    } else if (direction == 1) { // North-East
        _movement.x = _speed;
        _movement.y = -_speed;
    } else if (direction == 2) { // East
        _movement.x = _speed;
        _movement.y = 0;
    } else if (direction == 3) { // South-East
        _movement.x = _speed;
        _movement.y = _speed;
    } else if (direction == 4) { // South
        _movement.x = 0;
        _movement.y = _speed;
    } else if (direction == 5) { // South-West
        _movement.x = -_speed;
        _movement.y = _speed;
    } else if (direction == 6) { // West
        _movement.x = -_speed;
        _movement.y = 0;
    }else   {                    // North-West
        _movement.x = -_speed;
        _movement.y = -_speed;
    }
    Vector2D velocity = {_movement.x, _movement.y};
    return velocity;
} 
  
void EnemyBoss::enemyboss(N5110 &lcd)
{

    // draws the boss enemy for stage 3
    lcd.drawSprite(_a,_b,13,13,(int *)boss);
    // draws the first regular enemy for stage 3
    lcd.drawSprite(_c,_d,7,8,(int *)enemy2);
    // draws the first regular enemy for stage 3
    lcd.drawSprite(_e,_f,7,8,(int *)enemy2);
    
}

void EnemyBoss::update()
{
    _a += _movement.x; // updates the x position for the boss enemy
    _b += _movement.y; // updates the y position for the boss enemy
    
    // the first and second regular enemy stay stationery 
}


Vector2D EnemyBoss::get_movement()
{
    // gets the movement of the boss enemy
    Vector2D m = {_movement.x,_movement.y};
    return m;
}

void EnemyBoss::set_movement(Vector2D m)
{
    // sets the movement of the boss enemy
    _movement.x = m.x;
    _movement.y = m.y;
}
  
void EnemyBoss::add_health_boss()
{
    // increments the value of health by 1 for the boss enemy
    _health++;
}

int EnemyBoss::get_health_boss()
{
    // gets the value of boss health
    return _health;
}

void EnemyBoss::add_health_enemy1()
{
    // increments the value of health by 1 for the first regular enemy
    _health1++;
}

int EnemyBoss::get_health_enemy1()
{
   // gets the value of first regular enemy health
    return _health1;
}

void EnemyBoss::add_health_enemy2()
{
     // increments the value of health by 1 for the second regular enemy
    _health2++;
}

int EnemyBoss::get_health_enemy2()
{
    // gets the value of second regular enemy health
    return _health2;
}

Vector2D EnemyBoss::get_enemyboss_pos() 
{
    //gets the position of the boss enemy for stage 3
    Vector2D e = {_a,_b};
    return e;    
}

Vector2D EnemyBoss::get_enemy1_pos() 
{
    //gets the position of the first regular enemy for stage 3
    Vector2D d = {_c,_d};
    return d;    
}

Vector2D EnemyBoss::get_enemy2_pos() 
{
    //gets the position of the second regular enemy for stage 3
    Vector2D c = {_e,_f};
    return c;    
}

void EnemyBoss::set_enemyboss_pos(Vector2D e)
{
    //sets the position of the boss enemy for stage 3
    _a = e.x;
    _b = e.y;
}

void EnemyBoss::set_enemy1_pos(Vector2D d)
{
    //sets the position of the first regular enemy for stage 3
    _c = d.x;
    _d = d.y;
}

void EnemyBoss::set_enemy2_pos(Vector2D c)
{
    //gets the position of the second regular enemy for stage 3
    _e = c.x;
    _f = c.y;
}