#ifndef MINIENEMY_H
#define MINIENEMY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** MiniEnemy Class
 * @brief  Enemy for the minigame
 * @author Rex Roshan Raj
 */
class MiniEnemy
{

public:
    /** Constructor */
    MiniEnemy();
    
     /** Destructor */    
    ~MiniEnemy();
    
    /** Initialises the parameters */
    void init();
    
    /** Generates the location 
    * @brief Generates and sets the location of the enemy once it has been hit 
    */
    Vector2D location();
    
    /** Draws the enemy 
    * @param N5110 lcd
    * @brief Draws the enemy in stage one
    */
    void enemy(N5110 &lcd);
    
    /** Updates the movement 
    * @brief Changes the y position for animation once the enemy has died 
    */ 
    void update();
    
    /** Adds the value of score by 1 */          
    void add_score();
    
    /** Gets the value of the score 
    * @returns value in range 0 to 10
    */
    int get_score();
    
    /** Adds the value of health by 1 */          
    void add_health();
    
    /** Gets the value of the health 
    * @returns value in range 0 to 5
    */
    int get_health();
    
    /** Sets the value of the health 
    * @returns value of 0 
    */
    int set_health();
    
    /** Adds 1 to movement speed*/  
    void add_fast();
    
    /** Gets the value of the fast 
    * @returns value in range 1 to 7
    */
    int get_fast();
    
    /** Sets the value of the fast 
    * @returns value in range 0
    */
    int set_fast();
    
    /** Gets the position of the enemy
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_enemy_pos();
    
    /** Sets the position of the enemy 
    *   @param position of the enemy 
    */
    void set_enemy_pos(Vector2D e);
    
    
private:
   
    // methods
    Vector2D _location;
    int a;
    int b;
    int x;
    int y;
    int _fast;
    int _score;
    int _health;

};

#endif