#ifndef ENEMY_H
#define ENEMY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Enemy Class
 * @brief  Enemy for stage one
 * @author Rex Roshan Raj
 */
class Enemy
{

public:
    /** Constructor */
    Enemy();
    
     /** Destructor */    
    ~Enemy();
    
    /** Initialise all the parameters for enemy in stage one 
    *@param a - x position of the enemy
    *@param b - y position of the enemy
    */
    void init(int a,int b);
    
    /** Generates the location 
    * @brief Generates and sets the location of the enemy once it has been hit 
    */
    void location();
    
    /** Draws the enemy 
    * @param N5110 lcd
    * @brief Draws the enemy in stage one
    */
    void enemy(N5110 &lcd);
    
    /** Updates the movement 
    * @brief Changes the y position for animation once the enemy has died 
    */ 
    void update();
    
    /** Adds the value of health by 1 */          
    void add_health();
    
    /** Gets the value of the health 
    * @returns value in range 0 to 10
    */
    int get_health();
    
    /** Gets the position of the enemy
    * @returns a struct with x,y members which corresponds to x and y position respectively
    */
    Vector2D get_enemy_pos();
    
    /** Sets the position of the enemy 
    *   @param position of the enemy 
    */
    void set_enemy_pos(Vector2D e);
    
private:
   
    // methods
    int _a;
    int _b;
    int _speed;
    int _fast;
    int _health;

};

#endif