#include "Spacecraft.h"

// nothing doing in the constructor and destructor
Spacecraft::Spacecraft()
{

}

Spacecraft::~Spacecraft()
{

}

// sprite of the player spacecraft 
int H_spacecraft [11][11] = {
    
    { 0,0,1,0,0,1,0,0,0,0,0 },
    { 0,1,1,1,1,1,1,0,0,0,0 },
    { 0,0,1,0,0,1,0,0,0,0,0 },
    { 0,0,0,1,0,0,1,0,0,0,0 },
    { 0,1,1,0,0,0,0,1,1,0,0 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 0,1,1,1,1,1,1,1,1,0,0 },
    { 0,0,0,1,1,1,1,0,0,0,0 },
    { 0,0,1,1,1,1,0,0,0,0,0 },
    { 0,1,1,1,1,1,1,0,0,0,0 },
    { 0,0,1,0,0,1,0,0,0,0,0 },
    
    
};     

void Spacecraft::init(int x,int y) // initialise the x and y position
{
    _x = x;  // default x position
    _y = y;  // default y position
    _speed = 1;  // default speed
    _health = 0;  // start health from zero

}
    
void Spacecraft::character(N5110 &lcd)
{
    // draw the player's spacecraft in screen buffer. 
    lcd.drawSprite(_x,_y,11,11,(int *)H_spacecraft);
}


void Spacecraft::update(Direction d,float mag)
{
    _speed = int(mag*5.0f);  // scale is arbitrary, could be changed in future

    // update x and y value depending on the direction of the movement
    // North is decrement as origin is at the top-left so decreasing moves up
    // East is increment and West is decrement
    if (d == N) {
        _y-=_speed;
    } else if (d == S) {
        _y+=_speed;
    } else if (d == E) {
        _x+=_speed;
    } else if (d == W) {
        _x-=_speed;    
    } else if (d == NE) {
        _y-=_speed;
        _x+=_speed;    
    } else if (d == SE) {
        _y+=_speed;
        _x+=_speed;    
    } else if (d == NW) {
        _y-=_speed;
        _x-=_speed;    
    } else if (d == SW) {
        _y+=_speed;
        _x-=_speed;    
    } 
    // check the y origin to ensure that the spacecraft doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_x < 1) {
        _x = 1;
    }
    if (_y > HEIGHT - 12) {
        _y = HEIGHT - 12;
    }
    if (_x > WIDTH - 13) {
        _x = WIDTH - 13;
    }
}

void Spacecraft::update_move() // moves south when the spacecraft dies
{
    _increment = 5.0;
    
    _y+=_increment; 
}
    
void Spacecraft::add_health()
{
    _health++; // Adds health
}
int Spacecraft::get_health()
{
    return _health; // Gets the value of health
}

Vector2D Spacecraft::get_pos() 
{
    // Gets the position of the spacecraft
    Vector2D p = {_x,_y};
    return p;    
}
