#include "EnemyBeam.h"

EnemyBeam::EnemyBeam()
{

}

EnemyBeam::~EnemyBeam()
{

}

void EnemyBeam::init(int size,int a, int b) // initialising beam for the enemy in the first stage
{
    _size = size; // size of the beam 
    _x = _size;   // length of the beam
    _y = 1;       // height of the beam
    _a = a;       // x position of the enemy beam
    _b = b + 4;   // y position of the enemy beam 
}

void EnemyBeam::draw(N5110 &lcd)
{
    // draws the beam of the first stage enemy
    lcd.drawRect(_a,_b,_x,_y,FILL_BLACK);
}

void EnemyBeam::update()
{
    _speed = 5.0;  // the speed of the beam moving is set at 5

    _a-=_speed; // the beam moves in the negative x direction
    
}

Vector2D EnemyBeam::get_pos()
{
    // gets the position of the enemy beam
    Vector2D b = {_a,_b};
    return b;
}

void EnemyBeam::set_pos(Vector2D p)
{
    // sets the position of the enemy beam
    _a = p.x ;
    _b = p.y ;
}