#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "143.129.39.151"
#define BROKER_PORT     1883
#define CLIENTID    "Reinout"
#define TOPIC   "clubIOT/feedback"
#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

DigitalOut info(LED2);
DigitalOut connected(LED3);
EthernetInterface interface;
Timer timer;
MQTTNetwork network(&interface);
MQTT::Client<MQTTNetwork, Countdown> client(network);
MQTT::Message message;

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

//Connects to Network & MQTT
void connect(char* name){
    interface.connect();
    while(interface.get_ip_address()== NULL){
    }
    
    network.connect(BROKER_NAME, BROKER_PORT);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = name;
    data.username.cstring = "smartcity";
    data.password.cstring = "smartcity";
    client.connect(data);
    connected=1;
}

//Publishes MQTT data
void send(char* feedback){
    char buf[100];
    sprintf(buf, feedback);
    sprintf(buf+ strlen(buf), CLIENTID);
     // QoS 0
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    client.publish(TOPIC, message);
}

//Disconnects MQTT
void disconnect(void){
    client.unsubscribe(TOPIC);
    client.disconnect();
    network.disconnect();
    connected=0;
}

//Processes message arrived
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    info=1;
    //NOTE: Due to lack of working serial terminal, sends data to clubIOT/feedback for reading. This should be printf.
    char buf[100];
    sprintf(buf,"Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    send(buf);
    sprintf(buf,"Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    send(buf);
}

//Subscribe to MQTT topic
void subscribe(char* topic){
  client.subscribe(topic, MQTT::QOS2, messageArrived);
}


int main(int argc, char* argv[])
{
    connect("Reinout");
    subscribe("clubIOT/songmeta");
    //Connect button to interrupt
    InterruptIn button(USER_BUTTON);
    button.fall(callback(&button1_onpressed_cb));
    
    while(connected){
        if(!button1_busy && multiclick_state!=0){
            if(multiclick_state==1)
                send("like-");
            else if(multiclick_state==2)
                send("dislike-");
            else if(multiclick_state==4)
              //  if(connected==1)
                disconnect();
            //    else connect("Jef");
            multiclick_state=0;
        }
    }
    return 0;
}
