//
//  RingBuffer.h ... General purpose ring buffer library
//
//  Copyright 2012  Yoji KURODA
//
//  2009.11.13 ... Originally written in C by Y.Kuroda for Renesas H83664
//  2012.08.31 ... Code convert for mbed in C++
//

#ifndef _RINGBUFFER_H
#define _RINGBUFFER_H

class RingBuffer {

  protected:
    unsigned char* buf;
    unsigned int sp;
    unsigned int ep;
    int bufsize;

  public:
    RingBuffer(int _bufsize=100);
    ~RingBuffer();
    
    int save(unsigned char c);
    unsigned char read(void);
    int check(void);
    int buffersize(void){return bufsize;};
    int full(void){ return (check()>=bufsize-1 ? 1 : 0); };
};


#endif /* _RINGBUFFER_H */


