/**
@Brief Program implementation
@file main.cpp
@Author Renosi Momoh
@Date 1st May 2016
**/


#include "main.h"

int main()
{
    lcd.init();
    lcd.setBrightness(0.6); //set backlight
    lcd.printString("Renosi Momoh's",0,1); /** Setting the Introduction text to the screen when the mbed is turned on **/
    lcd.printString("Parking Sensor",0,2);
    lcd.printString("Project",16,3);
    lcd.printString("LEEDS UNIV.",0,5);
    lcd.refresh();
    introTune();
    wait(3);
    lcd.clear();
    lcd.refresh();
    r_led = 1;
    sw2.mode(PullNone); // Set pullup button 
    sw2.fall(&sw2_isr);
    sw3.mode(PullNone);
    sw3.fall(&sw3_isr);
    mainProg();

}


void mainProg()
{
    sw2.mode(PullNone);
    sw2.fall(&sw2_isr);


    while(1) {
        float ain = pot.read(); //set the potentiometer to return values between 0 and 1
        ain = pot.read();
        if (ain < 0.3 ) {
            classicMode(); //refresh the lcd display to show classic mode selection as the pot is changed
            if (g_sw2_flag) {
                g_sw2_flag = 0; //clear the flag
                buzzer.beep(1700,0.2);//make sound when sw2 is pressed
                active();
                beeping();//This function is called to vary the speaker with the distance for each subsequent function
            }
            
        }

        if (ain < 0.7 && ain > 0.3) {
            radarMode(); //show lcd selection of radar mode when pot value is changed.
            if (g_sw2_flag) {
                g_sw2_flag = 0; //clear the flag
                buzzer.beep(1700,0.2); //make sound when selection is chosen
                radar();
                beeping();

            }
            
        }
        if (ain > 0.7) {
            classicMode1();
            if (g_sw2_flag) {
                g_sw2_flag = 0; //clear the flag
                buzzer.beep(1700,0.2); //make sound when selection is chosen
                activeIn();
                beeping();
                
            }

        
        }
    }



}
float averageDistance() /** Divide the running total by 10 to get the average distance to get more accurate readings on the sensor**/
{
    int  a = sensor.getDistanceCm();
    int b = sensor.getDistanceCm();
    int c = sensor.getDistanceCm();
    int d = sensor.getDistanceCm();
    int e = sensor.getDistanceCm();
    int f = sensor.getDistanceCm();
    int g = sensor.getDistanceCm();
    int h = sensor.getDistanceCm();
    int i = sensor.getDistanceCm();
    int j = sensor.getDistanceCm();

    distance  = (a+b+c+d+e+f+g+h+i+j)/10;
    return distance;
}
float averageDistanceIn() /**Converting the distance from cm into inches **/
{
    distanceIn = distance*(0.394); //converting distance from cm into inches.
    return distanceIn;
}




void beeping()
/*
@Brief Function to create the effect of varying beeping sounds depending on how close the sensor is to an object interspersed with
the led changing color depending on the distance
 */
{
    int distance = averageDistance();

    if (distance > 250.0)  {
        i = 1.4;
        r_led = 1;
    }
    if (distance <= 250.0) {
        i = 1.2;
        r_led = 1;
    }
    if (distance < 200.0) {
        i = 1;
        r_led = 1;

    }
    if (distance < 150) {
        i = 0.7;
        r_led = 1; //Allows the Led to change color depending on sensor distances

    }
    if (distance < 100) {
        i = 0.5;
        r_led = 0;

    }
    if (distance <= 50) {
        i = 0.25;
        r_led = 0;

    }
    if (distance < 25) {
        i = 0.05;
        r_led = 0;
    }
    buzzer.beep(1000, 0.5);
    wait(i);
    buzzer.nobeep();
    wait(i);
}



void sweep() //This function allows the radar to change direction with line across the screen and vary the speed with time param t.
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);

    lcd.clear();
    lcd.drawLine(42,47,4,36,1);// Fourth and final trace to the left
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);

    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.refresh();

}
void sweepOne()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,10,25,1);//Third trace to the left
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);
    lcd.refresh();

}

void sweepTwo()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,21,15,1);//Second Line to the left
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.printString(str,1,0);
   lcd.printString("cm",12,0);

    lcd.refresh();
}

void sweepThree()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,32,11,1);//First Line to the left
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);

    lcd.refresh();

}

void sweepFour()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,42,9,1);
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);
    

    lcd.refresh();
}
void sweepFive()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.drawLine(42,47,42,9,1);
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);

    lcd.refresh();

}
void sweepSix()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,52,11,1);//First line to the right
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);
    lcd.refresh();
}

void sweepSeven()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,63,15,1);//Second Line to the right
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);
    lcd.refresh();
}

void sweepEight()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawLine(42,47,74,25,1);//Third trace on the right
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);

    lcd.refresh();
}

void sweepNine()
{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);
    lcd.clear();
    lcd.drawCircle(42,47,38,0);
    lcd.drawCircle(42,47,26,0);
    lcd.drawCircle(42,47,14,0);
    lcd.drawCircle(42,47,2,0);

    lcd.drawLine(42,47,80,36,1);//Fourth trace to the right
    lcd.drawLine(0,47,83,47,1);//centre line
    lcd.printString(str,1,0);
    lcd.printString("cm",12,0);
    lcd.refresh();
}

void sensingImage() /** @brief Function to allow the sensor to read distance in classic mode in centimetres and draw subsequent visual indication on the screen **/

{
    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);



    if (distance>250)  {
        lcd.clear();
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("cm",46,2.5);
        lcd.refresh();
    }
    if (distance<=250) {
        lcd.clear();
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("cm",46,2.5);
        lcd.refresh();
    }
    if (distance< 100) {
        lcd.clear();
        lcd.drawRect(14,12,5.5,24,1); // third rectangle to the left
        lcd.drawRect(64.5,12,5.5,24,1); // third rectangle to the right
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("cm",46,2.5);
        lcd.refresh();

    }
    if (distance < 40) {
        lcd.clear();
        lcd.drawRect(21,8.5,5.5,30,1); // second rectangle on the left
        lcd.drawRect(57.5,8.5,5.5,30,1);//second rectangle to the right
        lcd.drawRect(14,12,5.5,24,1); // third rectangle to the left
        lcd.drawRect(64.5,12,5.5,24,1); // third rectangle to the right
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("cm",46,2.5);
        lcd.refresh();



    }
    if (distance < 20.0) {

        lcd.clear();
        lcd.drawRect(28,5,5.5,36,1); //first rectangle to the left
        lcd.drawRect(50.5,5,5.5,36,1); // first rectangle to the right
        lcd.drawRect(21,8.5,5.5,30,1); // second rectangle on the left
        lcd.drawRect(57.5,8.5,5.5,30,1);//second rectangle to the right
        lcd.drawRect(14,12,5.5,24,1); // third rectangle to the left
        lcd.drawRect(64.5,12,5.5,24,1); // third rectangle to the right
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("cm",46,2.5);
        lcd.refresh();
    }

    lcd.refresh();

}
void sensingImageIn() /**Function to allow the sensor to read distance in classic mode in inches and provides visual indication also **/

{
    int distanceIn = averageDistanceIn();
    char str[14];
    sprintf(str,"%i",distanceIn);



    if (distance>250)  {
        lcd.clear();
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("in",46,2.5);
        lcd.refresh();
    }
    if (distance<=250) {
        lcd.clear();
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("in",46,2.5);
        lcd.refresh();
    }
    if (distance< 100) {
        lcd.clear();
        lcd.drawRect(14,12,5.5,24,1); // third rectangle to the left
        lcd.drawRect(64.5,12,5.5,24,1); // third rectangle to the right
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("in",46,2.5);
        lcd.refresh();

    }
    if (distance < 40) {
        lcd.clear();
        lcd.drawRect(21,8.5,5.5,30,1); // second rectangle on the left
        lcd.drawRect(57.5,8.5,5.5,30,1);//second rectangle to the right
        lcd.drawRect(14,12,5.5,24,1); // third rectangle to the left
        lcd.drawRect(64.5,12,5.5,24,1); // third rectangle to the right
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("in",46,2.5);
        lcd.refresh();



    }
    if (distance < 20.0) {

        lcd.clear();
        lcd.drawRect(28,5,5.5,36,1); //first rectangle to the left
        lcd.drawRect(50.5,5,5.5,36,1); // first rectangle to the right
        lcd.drawRect(21,8.5,5.5,30,1); // second rectangle on the left
        lcd.drawRect(57.5,8.5,5.5,30,1);//second rectangle to the right
        lcd.drawRect(14,12,5.5,24,1); // third rectangle to the left
        lcd.drawRect(64.5,12,5.5,24,1); // third rectangle to the right
        lcd.drawRect(7,15.5,5.5,18,1); // fourth rectangle to the left
        lcd.drawRect(71.5,15.5,5.5,18,1); // fourth rectangle to the right
        lcd.drawRect(1,19,4.5,12,1); //plot of fifth rectangle to the left
        lcd.drawRect(78.5,19,4.5,12,1);
        lcd.printString(str,35.5,2.5); // plot of fifth rectangle to the right
        lcd.printString("in",46,2.5);
        lcd.refresh();
    }

    lcd.refresh();

}




void sweepSpeed()
/**@Brief Function to create the effect of sweep speeds depending on how close the sensor is to an object **/
{

    int distance = averageDistance();
    char str[14];
    sprintf(str,"%i",distance);


    if (distance>250.0)  {
        t = 0.6;

    }
    if (distance<=200.0) {
        t = 0.5;

    }
    if (distance<100.0) {
        t = 0.4;


    }
    if (distance<80) {
        t = 0.8;


    }
    if (distance<60) {
        t = 0.2;


    }
    if (distance<40) {
        t = 0.1;
        lcd.printString(str,1,0);

    }
    if (distance<20) {
        t = 0.05;
        lcd.printString(str,1,0);
    }

    sweep();
    wait(t);
    sweepOne();
    wait(t);
    sweepTwo();
    wait(t);
    sweepThree();
    wait(t);
    sweepFour();
    wait(t);
    sweepFive();
    wait(t);
    sweepSix();
    wait(t);
    sweepSeven();
    wait(t);
    sweepEight();
    wait(t);
    sweepNine();
    wait(t);
    sweepEight();
    wait(t);
    sweepSeven();
    wait(t);
    sweepSix();
    wait(t);
    sweepFive();
    wait(t);
    sweepFour();
    wait(t);
    sweepThree();
    wait(t);
    sweepTwo();
    wait(t);
    sweepOne();
    wait(t);
    sweep();




}



void active() //Function containing the parking sensor measurements in cm

{
    sw3.mode(PullNone);
    sw3.fall(&sw3_isr);
    lcd.clear();
    ticker.attach(&timer_isr,1); //Ticker is attached to call function at specified rate of evry 0.5 seconds
    while (1) {
        if (g_timer_flag) {
            g_timer_flag = 0;
            sensingImage();
            lcd.refresh();
            beeping();
        }
        if (g_sw3_flag) { //Allows the sw2 to interrupt and call the main function when the back sw2 is pressed.
            g_sw3_flag = 0;
            ticker.detach();
            mainProg();

        }



        sleep(); //Allows the sensor to sleep when not calling the function to save power.
    }

}
void activeIn() //Function containing the implementation of the parking sensor function in inches

{
     sw3.mode(PullNone);
    sw3.fall(&sw3_isr);
    lcd.clear();
    ticker3.attach(&timer_isr,1);
    while (1) {
        if (g_timer_flag) {
            g_timer_flag = 0; //if it has, clear the flag
            sensingImageIn();
            lcd.refresh();
            beeping();
        }
        if (g_sw3_flag) { //Allows the button to interrupt and call the main function when the back button is pressed.
            g_sw3_flag = 0;
            ticker3.detach();
            mainProg();

        }



        sleep(); //Allows the sensor to sleep when not calling the function to save power.
    }

}

void radar()
{
    sw3.mode(PullNone);
    sw3.fall(&sw3_isr);
    lcd.clear();
    ticker2.attach(&timer_isr,0.5); //Sets another interrupt based system where the function is called periodically.
    while(1) {
        if (g_timer_flag) {
            g_timer_flag = 0;
            sweepSpeed();
            lcd.refresh();
            beeping();
        }
        if (g_sw3_flag) { //Allows the button to interrupt and call the main function when the back button is pressed.
            g_sw3_flag = 0;
            ticker2.detach();
            mainProg();

        }
        sleep();
    }

}


void introTune() /**@Brief Function defining introductory message **/
{

    buzzer.beep(350,1);//F
    wait(0.2);
    buzzer.beep(262,1);//C
    wait(0.2);
    buzzer.beep(294,1);//D
    wait(0.2);
    buzzer.beep(350,0.5);//F
    wait(0.2);
    buzzer.beep(350,0.5);
    wait(0.2);
    buzzer.beep(262,1);
    wait(0.2);
    buzzer.beep(294,1);
    wait(0.2);
    buzzer.beep(350,1);
    wait(0.2);
}



void classicMode() /** @brief Function to print on the screen when no selection is chosen **/
{
    lcd.clear();
    lcd.printString("SELECT A MODE:",0,0.5);
    lcd.printString("CLASSIC (cm)", 11,2);
    lcd.printString("RADAR MODE",11,3);
    lcd.printString("CLASSIC (in)",11,4);
    lcd.drawCircle(3,19.5,3,1);
    lcd.refresh();

}


void radarMode()
{
    lcd.clear();
    lcd.printString("SELECT A MODE:",0,0.5);
    lcd.printString("CLASSIC (cm)", 11,2);
    lcd.printString("RADAR MODE",11,3);
    lcd.printString("CLASSIC (in)",11,4);
    lcd.drawCircle(3,26.5,3,1);
    lcd.refresh();
}

void classicMode1()
{
    lcd.clear();
    lcd.printString("SELECT A MODE:",0,0.5);
    lcd.printString("CLASSIC (cm)", 11,2);
    lcd.printString("RADAR MODE",11,3);
    lcd.printString("CLASSIC (in)",11,4);
    lcd.drawCircle(3,34.5,3,1);
    lcd.refresh();
}


void sw2_isr()
{
    g_sw2_flag = 1;   // set flag in ISR
}
void sw3_isr()
{
    g_sw3_flag = 1;
}



void timer_isr()
{
    g_timer_flag = 1; /** @Brief Set flag in ISR **/
}
void timer2_isr()
{
    g_timer2_flag = 1; /** @Brief set flag 2 in ISR **/
}

void timer1_isr()
{

    g_timer1_flag = 1;
}