#include "mbed.h"

BusInOut colBus( p26, p25, p24);
const PinName rowPins[] = { p30, p29, p28, p27 };

volatile bool irqFinished = false;

inline char toChar( unsigned char r, unsigned char c) {
    static const char keytable[] = { '1', '2', '3', 'A',
                                     '4', '5', '6', 'B',
                                     '7', '8', '9', 'C',
                                     '*', '0', '#', 'D'
                                   };
    return keytable[r*4+c];
}

inline char toBinary( unsigned char r, unsigned char c) {
    static const char keytable[] = { 0x1, 0x2, 0x3, 0xC,
                                     0x4, 0x5, 0x6, 0xD,
                                     0x7, 0x8, 0x9, 0xE,
                                     0xA, 0x0, 0xB, 0xF
                                   };
    return keytable[r*4+c];
}

inline void start() {
    colBus.output();
    colBus = 0xF;
}

// simple log2, only 4bits needed
inline unsigned char _lg2( unsigned char c) {
    return c&1 ? 0 : c&2 ? 1 : c&4 ? 2 : 3;
}

inline char pin2Row(PinName pin) {
    return rowPins[0] == pin ? 0 : rowPins[1] == pin ? 1 : rowPins[2] == pin ? 2 : 3;
}

BusOut code(LED4, LED3, LED2, LED1); //show binary code of key

void checkColumn(PinName pinPressed) {
    {   //debounce
        DigitalIn in(pinPressed);
        for (char c=0; c<100; ++c) {
            if ( !in.read()) {
                irqFinished=true;
                return;  // key not long enough pressed
            }
            wait_us(100);
        }
    }
    // check column
    DigitalOut p(pinPressed);
    p = 0x1;
    colBus.input();
    unsigned char col = colBus.read();
    if (col) {
        col = _lg2(col);
        {   // blink to show key pressed
            code = 0;
            wait_ms(150);
            code = 0xF;
            wait_ms(150);
        }
        char row = pin2Row(pinPressed);
        code = toBinary(row,col);
//        printf("%d, %d, %c\r\n", row, col, toChar(row,col));
    }
    irqFinished = true;
}

void trigger27() {
    checkColumn(p27);
}
void trigger28() {
    checkColumn(p28);
}
void trigger29() {
    checkColumn(p29);
}
void trigger30() {
    checkColumn(p30);
}

void checkRow() {
    InterruptIn irqIn27(p27), irqIn28(p28), irqIn29(p29), irqIn30(p30);
    irqIn27.rise( &trigger27);
    irqIn28.rise( &trigger28);
    irqIn29.rise( &trigger29);
    irqIn30.rise( &trigger30);
}

int main() {
    while (1) {
        start();
        irqFinished = false;
        checkRow();
        while (!irqFinished);
    }
}
