#include "ble_meter.h"

GonioService::GonioService(BLEDevice &_ble, uint16_t hoek, uint16_t acc, uint16_t gyro):
        ble(_ble),
        G_ServiceUUID(0x9000),
        G_CharUUID(0x9001),
        G_ControlUUID(0x9002),
        gValueBytes(hoek,acc,gyro),
        dataChar(G_CharUUID, gValueBytes.getPointer(),
                 gValueBytes.getNumValueBytes(), GonioValueBytes::MAX_VALUE_BYTES,
                 GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        batteryChar(GattCharacteristic::UUID_BATTERY_LEVEL_CHAR, &batteryValue,
                    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        controlPoint(G_ControlUUID, &controlPointValue)
         {
        setupService();
        //;
    }
    
void GonioService::setupService(){
    static bool serviceAdded = false; /* We should only ever need to add the heart rate service once. */
        if (serviceAdded) {
            return;
        }
        init();
        //batteryLevel(GattCharacteristic::UUID_BATTERY_LEVEL_CHAR, &batteryValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
        GattCharacteristic *charTable[] = {&dataChar, &controlPoint,&batteryChar};
        GattService         GonioService(G_ServiceUUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.addService(GonioService);
        serviceAdded = true;

        ble.onDataWritten(this, &GonioService::onDataWritten);
        setupAdvertising();
}

 void GonioService::updateBattery(uint8_t newLevel) {
        batteryValue = newLevel;
        ble.updateCharacteristicValue(batteryChar.getValueAttribute().getHandle(), &batteryValue, 1);
}

uint8_t GonioService::getBatteryLevel(){
    return batteryValue;
}

void GonioService::updateGonio(uint16_t params, uint16_t acc, uint16_t gyro){
    gValueBytes.updateGonio(params,acc, gyro);
    ble.updateCharacteristicValue(dataChar.getValueAttribute().getHandle(), gValueBytes.getPointer(), gValueBytes.getNumValueBytes());
}

void GonioService::onDataWritten(const GattCharacteristicWriteCBParams *params){
    writeValue = 200;
        if (params->charHandle == controlPoint.getValueAttribute().getHandle()) {
            writeValue = params->data[0];
        }
}

uint8_t GonioService::getGServiceUUID(){
    return G_ServiceUUID;
}

/*
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    GonioService::ble.startAdvertising(); // restart advertising
}

void GonioService::periodicCallback(){
    // do nothing yet
}*/

void GonioService::init(){
    ble.init();
    //ble.setTxPower(4);
    //ble.onDisconnection(disconnectionCallback);
}

void GonioService::setupAdvertising(){
    const static char DEVICE_NAME[] = "GonioMeter";
    static const uint16_t uuid16_list[] = {G_ServiceUUID};
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.setAdvertisingInterval(50);
    ble.startAdvertising();
}


