/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_METER_H__
#define __BLE_METER_H__

#include "BLEDevice.h"
class GonioService {
public:
    GonioService(BLEDevice &_ble, uint16_t hoek, uint16_t acc, uint16_t gyro);

    void updateGonio(uint16_t params, uint16_t acc, uint16_t gyro);
    void updateBattery(uint8_t newLevel);
    void onDataWritten(const GattCharacteristicWriteCBParams *params);
    uint8_t getGServiceUUID();
    uint8_t getWriteValue();
    uint8_t getBatteryLevel();
    void setupService();

private:
    //void disconnectionCallback();
    //void periodicCallback();
    void init();
    void setupAdvertising();
    
    struct GonioValueBytes {
        static const unsigned MAX_VALUE_BYTES  = 6; /* FLAGS + up to two bytes for heart-rate */
        static const unsigned FLAGS_BYTE_INDEX = 0;
        static const unsigned VALUE_FORMAT_BITNUM = 0;
        static const uint8_t  VALUE_FORMAT_FLAG   = (1 << VALUE_FORMAT_BITNUM);


        GonioValueBytes(uint16_t params, uint16_t acc, uint16_t gyro) : valueBytes() {
            updateGonio(params,acc,gyro);
        }

        void updateGonio(uint16_t hoek, uint16_t acc, uint16_t gyro) {
            //valueBytes[FLAGS_BYTE_INDEX]    |= VALUE_FORMAT_FLAG;
            valueBytes[FLAGS_BYTE_INDEX ]    = (uint8_t)(hoek & 0xFF);
            valueBytes[FLAGS_BYTE_INDEX + 1] = (uint8_t)(hoek >> 8);
            valueBytes[FLAGS_BYTE_INDEX + 2] = (uint8_t)(acc & 0xFF );
            valueBytes[FLAGS_BYTE_INDEX + 3] = (uint8_t)(acc >> 8);
            valueBytes[FLAGS_BYTE_INDEX + 4] = (uint8_t)(gyro & 0xFF);
            valueBytes[FLAGS_BYTE_INDEX + 5] = (uint8_t)(gyro >> 8);
        }

        uint8_t       *getPointer(void) {
            return valueBytes;
        }

        const uint8_t *getPointer(void) const {
            return valueBytes;
        }

        unsigned getNumValueBytes(void) const {
            return MAX_VALUE_BYTES;
        }
        
        uint8_t getValue(int index){
            if(index >=0 && index<MAX_VALUE_BYTES ){
                return valueBytes[index];
            } else{
                return NULL;
            }
        }

private:
        uint8_t valueBytes[MAX_VALUE_BYTES];
    };
    
private:
    //const static char DEVICE_NAME[];
    //uint16_t uuid16_list[];    

    BLEDevice           &ble;
    uint16_t            G_ServiceUUID;
    uint16_t            G_CharUUID;
    uint16_t            G_ControlUUID;

    GonioValueBytes     gValueBytes;
    uint8_t             controlPointValue;
    uint8_t             writeValue;
    uint8_t             batteryValue;

    GattCharacteristic                      dataChar;
    GattCharacteristic                      batteryChar;
    WriteOnlyGattCharacteristic<uint8_t>    controlPoint;
};

#endif /* #ifndef __BLE_METER_H__*/