/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLEDevice.h"
#include  "ble_meter.h"

/* Enable the following if you need to throttle the connection interval. This has
 * the effect of reducing energy consumption after a connection is made;
 * particularly for applications where the central may want a fast connection
 * interval.*/
#define UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL 1

Serial pc(USBTX, USBRX); // tx, rx
BLEDevice  ble;
DigitalOut led1(LED1);

static volatile bool  triggerSensorPolling = false;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}

void periodicCallback()
{
    
    led1 = !led1; 
   
    // kijken hoe snel ble is

    triggerSensorPolling = true;
}

void batteryCallback(){
    
}
int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback,1); // blink LED every second

    ble.onDisconnection(disconnectionCallback);

    /* Setup primary service. */
    uint16_t hoek = 250; 
    uint16_t acc = 0;
    uint16_t gyro = 300;
    GonioService G_Service(ble, hoek,acc,gyro);       

    // infinite loop
    while (1) {
        // check for trigger from periodicCallback()
        if (triggerSensorPolling && ble.getGapState().connected) {
            triggerSensorPolling = false;
            
            // Do blocking calls or whatever is necessary for sensor polling.
            // In our case, we simply update the HRM measurement. 
            hoek++;
            acc++;
            gyro++;
            
            //  100 <= HRM bps <=175
            if (hoek == 350) {
                hoek = 250;
                acc = 0;
                gyro = 300;
            }
            
            // update bps
            //pc.printf("\n\r gelezen waarde: %d", G_Service.getWriteValue());
            G_Service.updateGonio(hoek,acc,gyro); // deze testen in de periodic callback
        } else {
            ble.waitForEvent(); // low power wait for event
       }
    }
}
