/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLEDevice.h"
#include "ble_feedback.h"


/* Enable the following if you need to throttle the connection interval. This has
 * the effect of reducing energy consumption after a connection is made;
 * particularly for applications where the central may want a fast connection
 * interval.*/
#define UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL 0

//BLEDevice  ble;
DigitalOut led1(LED1);
Serial pc(USBTX, USBRX); // tx, rx

static volatile bool  triggerSensorPolling = false;

/*void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}*/
/*
void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */

    /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
     * heavy-weight sensor polling from the main thread. */
    //triggerSensorPolling = true;
//}

int main(void)
{
    //led1 = 1;
    //Ticker ticker;
    //ticker.attach(periodicCallback, 1); // blink LED every second

    //ble.onDisconnection(disconnectionCallback);

    /* Setup primary service. */
    uint8_t battery = 100; 
    FeedbackService* FService = new FeedbackService();

    // infinite loop
    while (1) {
     // check for trigger from periodicCallback()
        if ( FService->isConnected() && FService->newValue()) {
            triggerSensorPolling = false;

            battery--;
            
            if (battery == 0) {
                battery = 100;
            }
            pc.printf("\n\r geschreven %d \n\r", FService->getTest());
            FService->updateBatteryValue(battery);
        } else {
            //ble.waitForEvent(); // low power wait for event
        }
    }
}
