#include "ble_feedback.h"

BLEDevice  _ble;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    _ble.startAdvertising(); // restart advertising
}

FeedbackService::FeedbackService():
        ble(_ble),
        bValueBytes(100),
        FServiceUUID(0x9100),
        writeUUID(0x9101),
        test(0),
        newValueFlag(false),
        batteryChar(GattCharacteristic::UUID_BATTERY_LEVEL_CHAR, bValueBytes.getPointer(),
                 bValueBytes.getNumValueBytes(), BatteryValueBytes::MAX_VALUE_BYTES,
                 GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        writeChar(writeUUID,&writeValue){
        setupService();                
    }
    
bool FeedbackService::isConnected(){
    return ble.getGapState().connected;
}
    
void FeedbackService::setupService(){
        printf("setting up");
        static bool serviceAdded = false; /* We should only ever need to add the heart rate service once. */
        if (serviceAdded) {
            return;
        }
        init();
        GattCharacteristic *charTable[] = {&batteryChar, &writeChar};
        GattService         FeedbackService(FServiceUUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.addService(FeedbackService);
        serviceAdded = true;

        ble.onDataWritten(this, &FeedbackService::onDataWritten);
        setupAdvertising();
    }
    
void FeedbackService::updateBatteryValue(uint8_t newBatValue){
    bValueBytes.updateBattery(newBatValue);
    ble.updateCharacteristicValue(batteryChar.getValueAttribute().getHandle(), bValueBytes.getPointer(), bValueBytes.getNumValueBytes());
    }
    
void FeedbackService::init(){
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    }    
    
void FeedbackService::setupAdvertising(){
    const static char DEVICE_NAME[] = "MrFeedback";
    static const uint16_t uuid16_list[] = {FServiceUUID};
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.setAdvertisingInterval(50);
    ble.startAdvertising();
    }
  
void FeedbackService::onDataWritten(const GattCharacteristicWriteCBParams *params){
        if(params->charHandle == writeChar.getValueAttribute().getHandle()) {
            test = params->data[0];
            printf("\n\r geschreven waarde: %d \n\r ",test);
           // printf("\n\r waarde writeValue: %d \n\r",writeValue);
        }
}

uint8_t FeedbackService::getTest(){
    return test;
}

bool FeedbackService::newValue(){
    if(newValueFlag){
        newValueFlag = false;
        return true;
    }else{
        return false;
    }
}
        