#ifndef __BLE_FEEDBACK_H__
#define __BLE_FEEDBACK_H__

#include "BLEDevice.h"
#include "mbed.h"



class FeedbackService {

public:
    FeedbackService();
    void updateBatteryValue(uint8_t newBatValue);
    void onDataWritten(const GattCharacteristicWriteCBParams *params);
    void setupService();
    uint8_t getTest();
    bool isConnected();
    bool newValue();
    
private:
    void init();
    void setupAdvertising();
    /*
    struct BatteryValueBytes {
        BatteryValueBytes(uint8_t battery);
        void updateBattery(uint8_t battery);
        uint8_t       *getPointer(void);
        const uint8_t *getPointer(void) const;
        unsigned getNumValueBytes(void) const;


private:
        uint8_t valueBytes[1];
    };*/
   
    struct BatteryValueBytes {
        static const unsigned MAX_VALUE_BYTES  = 1; 
        static const unsigned FLAGS_BYTE_INDEX = 0;
        static const unsigned VALUE_FORMAT_BITNUM = 0;
        static const uint8_t  VALUE_FORMAT_FLAG   = (1 << VALUE_FORMAT_BITNUM);


        BatteryValueBytes(uint8_t battery) : valueBytes() {
            updateBattery(battery);
        }

        void updateBattery(uint8_t battery) {
            valueBytes[FLAGS_BYTE_INDEX ]    = battery;
        }

        uint8_t       *getPointer(void) {
            return valueBytes;
        }

        const uint8_t *getPointer(void) const {
            return valueBytes;
        }

        unsigned getNumValueBytes(void) const {
            return MAX_VALUE_BYTES;
        }

private:
        uint8_t valueBytes[MAX_VALUE_BYTES];
    };
    
private:
    BLEDevice           &ble;
    
    BatteryValueBytes   bValueBytes;
    uint16_t            FServiceUUID;
    uint16_t            writeUUID;
    uint8_t             writeValue;
    uint8_t             test;
    bool                newValueFlag;

    GattCharacteristic                   batteryChar;
    WriteOnlyGattCharacteristic<uint8_t> writeChar;
};

#endif /* #ifndef __BLE_FEEDBACK_H__*/