#include "mbed.h"
#include "stdint.h"
#include "DS18B20.h"
#include "OLED160G1.h"
#include "uOLED.h"


DigitalInOut sensor(p23);     // sensor connected to pin 23

OLED160G1 oled(p9, p10, p8);
uOLED uoled(p9, p10, p8);

Ticker timer;                // used for our microsec timing
Serial pc(USBTX, USBRX);     // serial comms over usb back to console
float temp=0;



int main() {

    /*oled.init();
    oled.eraseScreen();
    oled.setTextBackgroundType(OLED_SET_TEXT_OPAQUE);
    oled.setFontSize(0);
      */                    //uOLED initialization...
    uoled.init();
    
    
    //oled.printf("===========\n");
    //oled.printf("DS18B20 Config\n");
    sensor.mode(PullUp);
    
    ROM_Code_t ROM_Code = ReadROM();
    /*oled.printf("Family code: 0x%X\n", ROM_Code.BYTES.familyCode);
    oled.printf("Serial Number: \n");
    for (uint32_t i = 6; i != 0; --i) {
        oled.printf("%02X%s", ROM_Code.BYTES.serialNo[i-1], (i != 1)?":":"\n");
    }
    oled.printf("CRC: 0x%X\n", ROM_Code.BYTES.CRC);
    */
    oled.locate(0,1);
    uoled.printf("Convertendo...\n");
    //uoled.drawText(1, 3, 3, 200, 100, 40, "Convertendo...\n");
    while (1) {
    showTemperature(&temp);
       oled.locate(2,3);
       oled.setFontSize(2);
        oled.printf("%.2f C",temp);
        wait(10);
    }
}

