#include "mbed.h"
#include "stdint.h"
#include "DS18B20.h"
#include "OLED160G1.h"
#include "uOLED.h"
#include "ds1307.h"

DigitalInOut sensor(p23);     //DS18b20 connected on pin 23
DS1307 my1307(p9,p10);        // start DS1307 class and give it pins for connections of the DS1307 device
OLED160G1 oled(p28, p27, p8);
AnalogIn input(p20);          //Voltage meter

Serial GSM(p13, p14);
Serial pc(USBTX,USBRX);

Ticker timer;                // used for our microsec timing

float temp=0;


unsigned char i = 0;
unsigned char j = 0;
char NumTel[] = "937831063";
unsigned char CtrlZ = 0x1A;
float volt=0;


int sec = 0;       // Values to set time with
int min = 32;
int hours = 13;
int day = 6;
int date = 23;
int month = 11;
int year = 12;
int loop = 10;     // Non zero value for the while loop

 void test_rw(int test) {
     if (test == 0) pc.printf("Last R/W operation passed!\n\r");
     else pc.printf("Last R/W operation failed!\n\r");
 }


int main() {


GSM.baud(9600);
GSM.format(8,Serial::None,1);

test_rw(my1307.settime( sec, min, hours, day, date, month, year));    // Set the time on the DS1307
     
     
    oled.init();
    oled.eraseScreen();
    oled.setTextBackgroundType(OLED_SET_TEXT_OPAQUE);
    oled.setFontSize(0);
    wait(.3);
    sensor.mode(PullUp);
    
    ROM_Code_t ROM_Code = ReadROM();
    
    test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));  // Read the time and display on screen
      pc.printf("seconds read are %.2D \n\r",sec);
      pc.printf("min read are %.2D \n\r",min);
      pc.printf("hour read are %.2D \n\r",hours);
      pc.printf("day read are %.2D \n\r",day);
      pc.printf("date read are %.2D \n\r",date);
      pc.printf("month read are %.2D \n\r",month);
      pc.printf("year read are %.2D \n\r",year);
    
    oled.locate(0,1);
    oled.eraseScreen();
    oled.printf("Temp Actual..\n");
    pc.printf("Temp Actual..\n");
    
    while (1) {
    volt = input.read()*3.3;
    showTemperature(&temp);
       oled.locate(2,3);
       oled.setFontSize(2);
        oled.printf("%.2f C",temp);
        wait(3600);


GSM.printf("AT+CMGF=1\r\n");
pc.printf("AT+CMGF=1\r\n");
wait(1);

GSM.printf("AT+CMGS=937831063\r\n");
pc.printf("AT+CMGS=937831063\r\n");
wait(1);

GSM.printf("%.2f C\r\n",temp);
GSM.printf("%.2f V\r\n", volt);
//GSM.printf("%c",CtrlZ);
pc.printf("%.2f C\r\n",temp);
pc.printf("%.2f V\r\n", volt);

test_rw(my1307.gettime( &sec, &min, &hours, &day, &date, &month, &year));
        oled.locate(0,1);            // Print and refresh data on line 2 of the oled display     
        oled.setFontSize(0);
        oled.printf("\r%.2D",hours);
        GSM.printf("%.2D",hours);
        oled.printf(":%.2D",min);
        GSM.printf(":%.2D",min);
        oled.printf(":%.2D\r\n",sec);
        GSM.printf(":%.2D",sec);
        oled.printf("   %.2D",date);
        GSM.printf("   %.2D",date);
        oled.printf("/%.2D",month);
        GSM.printf("/%.2D",month);
        oled.printf("/%.2D\r\n",year);
        GSM.printf("/%.2D",year);
        if (day == 1){
            oled.printf("   Domingo \n");
            GSM.printf("   Domingo \n");
            }
        if (day == 2){
            oled.printf("   Segunda \n"); 
            GSM.printf("   Segunda-Feira \n");
            }  
        if (day == 3){
            oled.printf("   Terca \n");
            GSM.printf("   Terca-Feira \n");
            }
        if (day == 4){
            oled.printf("   Quarta \n");
            GSM.printf("   Quarta-Feira \n");
            }
        if (day == 5){
            oled.printf("   Quinta \n");
            GSM.printf("   Quinta-Feira \n");
            }
        if (day == 6){
            oled.printf("   Sexta \n");
            GSM.printf("   Sexta-Feira \n");
            }
        if (day == 7){
            oled.printf("   Sabado \n");
            GSM.printf("   Sabado \n");
            }
GSM.printf("%c",CtrlZ);
    }
}

