#include "mbed.h"
#include "stdint.h"
#include "DS18B20.h"
#include "OLED160G1.h"
#include "uOLED.h"


DigitalInOut sensor(p23);     //DS18b20 connected on pin 23

OLED160G1 oled(p28, p27, p8);
AnalogIn input(p20);          //Voltage meter

Serial GSM(p13, p14);
Serial pc(USBTX,USBRX);

Ticker timer;                // used for our microsec timing

float temp=0;


unsigned char i = 0;
unsigned char j = 0;
char NumTel[] = "937831063";
unsigned char CtrlZ = 0x1A;
float volt=0;

int main() {


GSM.baud(9600);
GSM.format(8,Serial::None,1);

    oled.init();
    oled.eraseScreen();
    oled.setTextBackgroundType(OLED_SET_TEXT_OPAQUE);
    oled.setFontSize(0);
    
    sensor.mode(PullUp);
    
    ROM_Code_t ROM_Code = ReadROM();
    
    oled.locate(0,1);
    oled.printf("Temp Actual..\n");
    
    while (1) {
    volt = input.read()*3.3;
    showTemperature(&temp);
       oled.locate(2,3);
       oled.setFontSize(2);
        oled.printf("%.2f C",temp);
        wait(600);


GSM.printf("AT+CMGF=1\r\n");
wait(1);

GSM.printf("AT+CMGS=937831063\r\n");
wait(1);

GSM.printf("%.2f C\r\n",temp);
GSM.printf("%.2f V\r\n", volt);
GSM.printf("%c",CtrlZ);



    }
}

