/*
*RenBuggy_Ultrasonic
*
*A Program that allows the RenBuggy to avoid obstacles using two HC-SR04
*ultrasonic modules.
*
*Copyright (c) 2016 Elijah Orr

*Permission is hereby granted, free of charge, to any person obtaining a copy 
*of this software and associated documentation files (the "Software"), to deal
*in the Software without restriction, including without limitation the rights 
*to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    
*copies of the Software, and to permit persons to whom the Software is        
*furnished to do so, subject to the following conditions:                     
                                                                             
*The above copyright notice and this permission notice shall be included in   
*all copies or substantial portions of the Software.                          
                                                                             
*THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   
*IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     
*FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  
*AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       
*LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    
*THE SOFTWARE.
*/

//include files - mbed library and our ultrasonic library
#include "mbed.h"
#include "ultrasonic_buggy.h"

//The main function is where the program will begin to execute
int main(){
    
    //create two floating point vairables to store distance readings in
    float left_distance;
    float right_distance;
    //call the stop function to make sure buggy is stationary
    stop();
    //wait for some setup time
    wait(5);
    //the code in this while loop will always execute and will repeat forever
    while(1){
        
        //take a distance reading from each of the sensors
        left_distance = getDistance_l();
        right_distance = getDistance_r();
        
        //if there is an object on the left, turn right
        if(left_distance < 0.4){
          right(0.1);
        }
        //else if there is an object on the right, turn left
        else if(right_distance < 0.4){
            left(0.1);
        }
        //else move forwards
        else{
            forward(0.1);
        }
        //code loops back to start of while loop
    }
}

