/*********************************************************
*RenBED_RGB_PWM                                          *
*Author: Elijah Orr                                      *
*                                                        *
*A program that changes the colour of an RGB LED by      *
*changing the duty cycle of PWM outputs to the colour    *
*cathodes of the LED.                                    *  
*********************************************************/

/* include the mbed library made by mbed.org that contains 
classes/functions designed to make programming mbed 
microcontrollers easier */
#include "mbed.h"

/* Set up 3 pins as PWM out to control the colour
cathodes of the RGB LED */
PwmOut Red(PWM5);
PwmOut Green(PWM7);
PwmOut Blue(PWM6);

/* the main function is where a program will begin to execute. */

/****************************************************************
* Function: main()                                              *
*                                                               *
* Sequences an RBG LED connected to the RenBED                  *
*                                                               *
* Inputs: none                                                  *
*                                                               *
* Returns: none                                                 *
****************************************************************/
int main()
{
    /* open a for loop with no parameters to start an infinite loop */
    for(;;){
        Red = 0.7;                  /* Duty cycle on red pin set to 70% so red is on 30% of the time */
        Green = 0.4;
        wait_ms(3000);              /* wait for 3000 ms (3 seconds) */
        Red = 1;                    /* Duty cycle set to 100% to turn red off */
        Blue = 0;                   /* Duty cycle set to 0% to turn blue fully on */  
        wait_ms(3000);
        Green = 1;
        wait_ms(3000);
        Red = Green = Blue = 1;
        wait_ms(3000);
        Blue = 0;
        wait_ms(3000);
    }
}
        
        