/*********************************************************
*RenBED_RGB                                              *
*Author: Elijah Orr                                      *
*                                                        *  
*A program that cycles through the 9 different states    *
*(including off) of a common anode RGB LED that are      *
*available via digital pin control.                      *
*********************************************************/

/* include the mbed library made by mbed.org that contains 
classes/functions designed to make programming mbed 
microcontrollers easier */
#include "mbed.h"

/* Set up 3 pins as digital out to control the colour
cathodes of the RGB LED */
DigitalOut Red(p18);
DigitalOut Green(p20);
DigitalOut Blue(p19);

/* the main function is where a program will begin to execute. */

/****************************************************************
* Function: main()                                              *
*                                                               *
* Sequences an RBG LED connected to the RenBED                  *
*                                                               *
* Inputs: none                                                  *
*                                                               *
* Returns: none                                                 *
****************************************************************/
int main()
{
    /* open a for loop with no parameters to start an infinite loop */
    for(;;){
        Red = 0;                    /* As we are controlling colour cathodes, we must pull the pin low to turn on the colour */
        wait_ms(1000);
        Blue = 0;                   /* Colours are combined by switching multiple colour pins on at once */
        wait_ms(1000);
        Red = 1;                    /* Pull the red pin high to switch it off */
        wait_ms(1000);
        Green = 0;
        wait_ms(1000);
        Blue = 1;
        wait_ms(1000);
        Red = 0;
        wait_ms(1000);
        Red = 1;
        Blue = 0;
        wait_ms(1000);
        Red = 0;
        wait_ms(1000);
        Red = Blue = Green = 1;     /* Switch off all colours */
        wait_ms(1000);
    }
}
        
        