/*********************************************************
*buggy_functions.h                                       *
*Author: Elijah Orr & Dan Argust                         *
*                                                        *
*A library of functions that can be used to control the  *
*RenBuggy.                                               *
*********************************************************/

/* include guards are used to prevent problems caused by 
multiple definitions */
#ifndef BUGGY_FUNCTIONS_H
#define BUGGY_FUNCTIONS_H

/* mbed.h must be included in this file also */
#include "mbed.h"

/* #define LeftMotorPin p5 tells the preprocessor to replace
any mention of LeftMotorPin with p5 etc. */
#define LEFT_MOTOR_PIN P0_9
#define RIGHT_MOTOR_PIN P0_8

/* define pins to be used to operate the ultrasonic */
#define TRIGGER_PIN P0_11
#define LEFT_ECHO_PIN P1_20
#define RIGHT_ECHO_PIN P0_12

#define SPEED_OF_SOUND 340      //speed of sound =~340m/s at standard conditions

/* these are function prototypes that declare all the functions
in the library.*/
extern void forward(float); //Move the buggy forward for (float) seconds
extern void left(float); //Turn left for (float) seconds
extern void right(float); //Turn right for (float) seconds
extern void hold(float); //Hold the buggy in an idle state for (float) seconds
extern void stop(); //Stop all motors

extern float getDistance_l(void);
extern float getDistance_r(void);
void resetSR04(void);

#endif // BUGGY_FUNCTIONS_H