/****************************************************************
* LightSeekingRobot                                             *
* Author: Elijah Orr                                            *
*                                                               * 
* This program uses the values of two analog inputs (LDRs) to   *
* steer the RenBuggy via a servo motor.                         *
*****************************************************************/

/* The library ServoDrive is used in this program to control the 
servo and drive motors. Libraries are a useful tool for creating
code that can be reused in multiple programs. */
#include "mbed.h"
#include "ServoDrive.h"

AnalogIn LDR1(p15);
AnalogIn LDR2(p16);

/****************************************************************
* Function: main()                                              *
*                                                               *
* Steers a servo controlled wheel of the Renbuggy according to  *
* the relative light levels of two LDRs                         *
*                                                               *
* Inputs: none                                                  *
*                                                               *
* Returns: none                                                 *
****************************************************************/
int main()
{
    /* variables that will be used in the main are declared */
    float angle;
    float LDR1value;
    float LDR2value;
    int i;
    
    /* these variables are initialised values to be used to 
     control certain behaviors of the buggy. tolerance sets
     how much the light levels must differ for it to turn,
     centreValue is the value in degrees that corresponds to
     the wheel pointing directly forward, and difAdjust is 
     used make the values of the two LDR inputs more similar */
    float tolerance = 0.03;
    int centreValue = 45;
    float difAdjust = 0.03;
    
    /* call the function to set up the PWM signal for the servo */
    configurePWM(20000, 1500);
    
    /* the angle of the servo is initially set to centre it */
    angle = centreValue;
    
    /* start the buggy moving */
    go();
    
    /* opening a for loop without any conditions starts an infinite
    loop, so that the contained code runs forever */
    for(;;)
    {
        /* the class member function read() in AnalogIn.h reads the
        voltage of the of the LDR pins into variables as a floating
        point value between 0.0 and 1.0 */       
        LDR1value = LDR1.read();
        LDR2value = LDR2.read();
        
        /* LDR2value has difAdjust added to it to make both LDR values
        similar enough to compare effectively. The value 0.03 stored in
        difAdjust was chosen by printing the LDR values to console via
        USB and observing the difference between values (USBSerial.h was 
        used for this) */
        LDR2value = LDR2value + difAdjust;
        
        /* the behavior of the RenBuggy is defined by a series of if
        statements. If the conditions in the parentheses are true,
        then the code in the if statement will run, if not the program
        moves on. */
        
        /* && is known as the logical AND operator. If both operands are 
        non zero (i.e. true), then the condition will be true. If one LDR
        value is significantly larger than the other, then angle will 
        increment (angle++ means that the value of angle will increase
        by one) */
        if((LDR1value - LDR2value > tolerance) && (angle < 90)){
            angle++;
        }
        
        /* if statements can be followed by an optional else if statement, 
        which will execute when the above if statement is false, and the 
        else if condition is true. */
        else if((LDR2value - LDR1value > tolerance) && (angle > 0)){
             angle--;   /* angle-- means that angle will decrease by one */
        }
        
        /* If the difference between values is within tolerance, point the 
        wheel straight forward */
        else if((LDR1value - LDR2value < tolerance) && (LDR2value - LDR1value < tolerance)){
            angle = centreValue;
        }
        
        /* a for loop is used to create a delay in the program to make it run
        a little slower, so that the servo position is updated less freqently */
        for(i=0;i<400000;i++){}
        
        /* the function setDirection is called and passed the variable angle to
        set the servo position to the new value of angle */
        setDirection(angle);
    }
}
        
        
             
        
        
        
        
    
    
    