/*********************************************************
*ServoDrive.h                                            *
*Author: Elijah Orr                                      *
*                                                        *  
*A library of functions that can be used to control the  * 
*RenBuggy via a servo motor.                             *
*********************************************************/

/* include guards are used to prevent problems caused by 
multiple definitions */
#ifndef SERVODRIVE_H
#define SERVODRIVE_H

/* mbed.h must be included in this file also */
#include "mbed.h"

/* #define is used to set the pins that will be used to control the motors.
Using this method means that selecting which pins are used requires only
changing values here, rather than in every function that contains them.  */
#define servoPin p10
#define LeftMotorPin p5
#define RightMotorPin p6

/* function declarations go here */
extern void go();
extern void stop();
/* setDirection takes a variable of type float (non integer) that will represent an angle in
degrees. */
extern int setDirection(float);
/* configurePWM expects two variables of type int */
extern void configurePWM(int, int);

#endif //SERVODRIVE_H