/*********************************************************
*RenBuggyServoCtrl                                       *
*Author: Elijah Orr                                      *
*                                                        *  
*This program demonstates use of a library of functions  *
*(ServoDrive) to control the movement of the RenBuggy.   *
*                                                        *
*********************************************************/

/* include the libraries in use in this program. ServoDrive is a library that can
be used to control a steering servo and two drive motors. */
#include "mbed.h"
#include "ServoDrive.h"

/* open the main function */
int main()
{
    /* instead of using wait() to make delays in the program, for loops will be used
    as the wait function caused some buggy behaviour. The for loops will require a
    variable so it is declared at the top of the main, this is where all variables
    used in the main function should be declared. */
    int i;
    
    /* the first function to be called from ServoDrive.h is used to configure the PWM 
    output that controls the servo. Both parameters are values in micro seconds that 
    correspond to the period (20000) and pulsewidth (1500) of the PWM signal. 1500
    corresponds the the servo in centre postion after the line executes. */
    configurePWM(20000, 1500);
    
    /* function to start the drive motors going is called */
    go();
    
    /* the first delay goes here to make the buggy move forward for a time before 
    turning. The for loop will initialise the variable i to be 0, and enter the 
    program into a loop that will repeatedly check that i < 25000000 and increment 
    i as long as the statement is true. When i = 25000000 the program will exit the 
    loop and move on to the next line. */
    for(i=0;i<25000000;i++){}
    
    /* the function to set the direction the servo controlled wheel is facing is 
    called. It takes a single parameter that can be any number between 0 and 90,
    which represents a value in degrees where 45 points the wheel directly forward. */
    setDirection(70);
    for(i=0;i<25000000;i++){}
    
    setDirection(10);
    for(i=0;i<25000000;i++){}
    
    setDirection(90);
    for(i=0;i<25000000;i++){}
    
    setDirection(30);
    for(i=0;i<25000000;i++){}
    
    /* function to stop the drive motors is called */
    stop();
    
    return 0;
}
    