/*
This file is a Snootlab's header file's translation to use Akene on mbed boards instead of Arduino ones.
The functions Akene.begin() and Akene.send() work perfectly, but no real checkup has been made for the other functions.
Feel free to implement what you want to make your device work on mbed.

This translation is due to a Polytech Paris UPMC project led by Rémi Jourdain with the help of Clément Maciejewski.

Visit <http://snootlab.com>
Copyright (C) 2013-2015 Snootlab. All rights reserved.

Akene is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Akene is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Akene.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef AKENE_H
#define AKENE_H

#include "mbed.h"

class Akene_ {
    public:
        Akene_();
        ~Akene_();
        void begin();
        bool isReady();
        bool send(const void* data, uint8_t len);
        uint8_t getRev();
        unsigned long getID();
        bool setPower(uint8_t power);

        enum RETURN_CODE {
            OK = 'O',
            KO = 'K',
            SENT = 'S'
        };

    private:
        Serial _serial;
        unsigned long _lastSend;
        Timer _T;
        uint8_t _nextReturn();
};

extern Akene_ Akene;

#endif