#include "mbed.h"
#include "CAR.h"
#include "SRF08.h"
#include "Servo.h"

#define BAT 7.5

DigitalOut S2 (p11);
AnalogIn opt (p15);
//AnalogIn batterie (p20);
Serial bth(p13,p14);
//Serial sbt(p9, p10); // tx, rx
SRF08 srf08(p28, p27, 0xE0);
//Servo myservo(p26);

float aMes[]= {0,0,0};
PwmOut servo(p26);
int iState = 1;
bool bState =0;

char Adress = 128;
char action;
CAR robot(p9,p10);
//CAR robot;

void act()
{
   //bth.printf("Batterie : %.2f\n\r", batterie.read()*36.30);
    action=bth.getc();
    switch(action) {
        case 'a':
            bth.printf("avancer\n\r");
            robot.avancer(70);
            break;
        case 's':
            bth.printf("stop\n\r");
            robot.arreter();
            break;
        case 'u':
            bth.printf("arret\n\r");
            robot.arreter();
            break;
        case 'r':
            bth.printf("reculer\n\r");
            robot.reculer(70);
            break;
        case 'd':
            bth.printf("droite\n\r");
            robot.tourner_droite(70);
            break;
        case 'g':
            bth.printf("gauche\n\r");
            robot.tourner_gauche(70);
            break;
        case 'h':
            bth.printf("demi tour horaire\n\r");
            robot.demi_tour_droite(100);
            break;
        case'l':
            bth.printf("demi tour left\n\r");
            robot.demi_tour_gauche(100);
            break;
        case 'o':
            bState = !bState;
            //iState = 0;
            break;
    }
    action='0';
}


////////////////////////////////////////////

int main()
{
    S2=0;
    int visu;
    bth.baud(57600);
    bth.attach(&act);
    bState = 1;
    servo.period(0.02);
    while(1) {
        if (bState) {
            switch (iState) {

                case 0:

                    if (srf08.read() <40 and srf08.read() >0 ) {
                        iState = 1;
                        bth.printf("stop\n\r");
                        robot.arreter();
                    } else {
                        servo.write(0.08);
                        bth.printf("avancer\n\r");
                        robot.avancer(50);
                    }
                    break;

                case 1 :
                    servo.write(0.05);
                    wait (0.4);
                    aMes[1] = srf08.read();

                    servo.write(0.095);
                    wait (0.4);
                    aMes[2]= srf08.read();

                    servo.write(0.08);
                    
                    bth.printf("capt 1 : %.2f     capt 2 : %.2f",aMes[1], aMes[2]);
                    //if (aMes[1] <80 and aMes[1] >0)
                    if (aMes[2]>40) {
                        action = 'g';
                        bth.printf("gauche\n\r");
                        robot.tourner_gauche(70);
                    //} else if (aMes[2] <80 and aMes[2] >0) {
                    } else if (aMes[1]>40) {
                        bth.printf("droite\n\r");
                        robot.tourner_droite(70);
                    } else {
                        bth.printf("demi tour horaire\n\r");
                        robot.demi_tour_droite(100);
                    }
                    iState = 0;
                    break;
            }
        }
        visu=opt.read_u16();
        visu=422006/(visu-3475);
        //bth.printf("Measured range : %.2f cm\n",srf08.read());
    }
}

