#include "Kalibratie.h"
#include "Filterdesigns.h"

int samples = 100;              // amount of samples taken
double KalibratieMax(AnalogIn& emg, bool side){  //Calibration max value (contracted)   
    double ymax = 0;    
    for(int i = 1; i <= samples; i++) {         //amount of samples       
        double u = emg.read();
        double y = 0;
        if(side){                               // left EMG filter values
            y = FilterdesignsLeft(u);
            }
        else {
            y = FilterdesignsRight(u);           // right EMG filter values
            }        
        if (y > ymax && i >= samples / 10) {     //Check on maximum, not first 10 samples (offset)
            ymax = y;
            }
        wait(0.05);   
        }
    return ymax;
    }

double KalibratieMin(AnalogIn& emg, bool side){  //Calibration min value (relaxed)    
    double ymin = 10;
    for(int i = 1; i <= samples; i++) {
        double u = emg.read();
        double y = 0;
        if(side){                               // left EMG values
            y = FilterdesignsLeft(u);
            }
        else {
            y = FilterdesignsRight(u);           // right EMG values
            }  
        if (y < ymin && i >= samples / 10) {    // not first 10 samples (offset)
            ymin = y;
            }
        wait(0.05);  
        }
    return ymin;
}