#include "Filter.h"
// According to Direct form 2, see sheets of T.J.W. Lankhorst
    // u = input (without filter)
    // v = memory (by reference    
    // a1 and a2 variabel from ASN filter, a0 =1
    // b0, b1, b2 variabel from ASN filter       
double Filter(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2, const double gain){    
    double v = u - a1 * v1 - a2 * v2;
    double y = gain * (b0 * v + b1 * v1 + b2 * v2);    
    v2 = v1;                            // shift memory
    v1 = v;    
    return y;                           // filtered output
    }